#ifndef ___OPTIMIZE_3STATE_MODEL
#define ___OPTIMIZE_3STATE_MODEL

#include "definitions.h"
#include "tree.h"
#include "stochasticProcess.h"
#include "sequenceContainer.h"
#include "threeStateModel.h"
#include "likelihoodComputation.h"
#include "computePijComponent.h"
#include "computeUpAlg.h"


class optimizeThreeStateModel {
public:
	explicit optimizeThreeStateModel(tree& et,
		stochasticProcess& sp, sequenceContainer &sc, 
		bool optimizeMu1 = true, bool optimizeMu2 = true,
		bool optimizeMu3 = true,bool optimizeMu4 = true,
		bool optimizePi0 = true, bool optimizePi1 = true,
		const MDOUBLE upperBoundMuVals = 5,
		const MDOUBLE epsilonOptimization = 0.01);
	MDOUBLE getBestMu1() {return _bestMu1;}
	MDOUBLE getBestMu2() {return _bestMu2;}
	MDOUBLE getBestMu3() {return _bestMu3;}
	MDOUBLE getBestMu4() {return _bestMu4;}
	MDOUBLE getBestL() {return _bestL;}

private:
	MDOUBLE _bestMu1;
	MDOUBLE _bestMu2;
	MDOUBLE _bestMu3; // for non-reversible model only
	MDOUBLE _bestMu4; // for non-reversible model only
	MDOUBLE _bestPi0; 
	MDOUBLE _bestPi1; 
	MDOUBLE _bestL;
};

class evalParam{
public:
	enum paramName {mu1, mu2, mu3, mu4, pi0, pi1};
public:
	evalParam(const tree& et,
		stochasticProcess& sp, sequenceContainer &sc,paramName myparamName, bool isReversible)
		: _et(et),_sp(sp), _sc(sc),_paramName(myparamName),_isReversible(isReversible){};
private:
	const tree& _et;
	stochasticProcess& _sp;
	const sequenceContainer &_sc;
	paramName _paramName;
	bool _isReversible;
public:
	MDOUBLE operator() (MDOUBLE val);
};

#endif // ___OPTIMIZE_3STATE_MODEL
