#ifndef ___LGT_3STATE____H
#define ___LGT_3STATE____H


#include "tree.h"
#include "logFile.h"
#include "someUtil.h"
#include "definitions.h"
#include "stochasticProcess.h"
#include "sequenceContainer.h"
#include "threeStateModel.h"
#include "suffStatComponent.h"
#include "computePijComponent.h"
#include "simulateJumps.h"

#include <map>


class assess3stateLGT {

public:
	explicit assess3stateLGT(int argc, char* argv[]);
	explicit assess3stateLGT(tree &tr, sequenceContainer &sc, bool isNullModel=false,
		string *rootAt = NULL, 
		MDOUBLE *fixedMu1=NULL,MDOUBLE *fixedMu2=NULL,
		MDOUBLE *fixedMu3=NULL,	MDOUBLE *fixedMu4=NULL,
		string *resFile = NULL, string *logFile = NULL);
	virtual ~assess3stateLGT() ;
	MDOUBLE getLikelihood();
	MDOUBLE getMu1() {return static_cast<threeStateModel*>((*_sp).getPijAccelerator()->getReplacementModel())->getMu1();}
	MDOUBLE getMu2() {return static_cast<threeStateModel*>((*_sp).getPijAccelerator()->getReplacementModel())->getMu2();}
	MDOUBLE getMu3() {return static_cast<threeStateModel*>((*_sp).getPijAccelerator()->getReplacementModel())->getMu3();}
	MDOUBLE getMu4() {return static_cast<threeStateModel*>((*_sp).getPijAccelerator()->getReplacementModel())->getMu4();}
	/*******functions related to computation of expectaion */
	void computePosteriorOfChangeGivenTerminals(VVVdouble &posteriorPerNodePer2States);
	MDOUBLE computeExpectationOfChange(
		simulateJumps &sim, //input given from simulation studies
		VVVdouble &posteriorProbs,
		int fromState, int toState);
	void computePosterior(
		simulateJumps &sim, //input given from simulation studies
		VVVdouble &posteriorProbs);
	MDOUBLE computeExpectationOfChangePerBranch(
		simulateJumps &sim, //input given from simulation studies
		VVVdouble &posteriorProbs,
		tree::nodeP node,
		int fromState, int toState);
private:
	MDOUBLE computePosterioGivenTerminalsPerBranch(int nodeId,
		int sonState, int fatherState,suffStatGlobalHomPos &sscUp,
		suffStatGlobalGamPos &sscDown,computePijHom &pi, MDOUBLE &LLData);
	//compute Prob(letter at Node N is x|Data): the posterior probabilities at ancestral states 
	void computeAncestralPosterior(const VVVdouble& jointPost);
	MDOUBLE computePosteriorPerBranch(simulateJumps &sim, //input given from simulation studies
		VVVdouble &posteriorProbs,
		tree::nodeP node,
		int fromState, int toState);
public:
	/*******functions related to reconstruction */
	void traverseUpML(VVdouble &upL, VVint &backtrack); // input as empty vector to be filled
	MDOUBLE traverseDownML(VVdouble &upL, VVint &backtrack, VVint &transitionTypeCount); // input as already filled vector
	MDOUBLE logLikelihoodOfRecontructedTree();

private:
	void initialize(int argc, char* argv[]);
    void checkParameters();
	void checkIfNullModel();
	bool checkIfZeroFreqs();
	void rootTree();
	void runOptimization();
	void runMultipleStartingPoints(int numStartingPoints);
	void runComputationsAfterOptimization();
	void printResults();
	void preparePrintData(Vstring &data);//prepares the data to be printed as BP data on the tree
	void startStochasticProcess();
	void initializeStatesVector();
	
private:
	stochasticProcess *_sp; // for ML
	Vint _states; // the vector with the states of the leaves, to be filled with reconstructed states
	tree _tr;
	sequenceContainer _sc;
	string _outPutFile;
	string _logFile;
	string _rootAt;
	vector<double*> _initParameters; // to contain values of initial defined parameters, if they exist
						// the first parameter corresponds to mu1, the second to mu2, third to mu3, fourth to mu4
						//the 5th parameter is pi0, the sixth is pi1
	vector<bool> _doOptimizeParams; //the order of the parameters is the same as in _initParameters
	bool _isNullModel;
	bool _useMarkovLimiting; // should the markov limiting distribution be used to estimate the root frequencies
	int _multipleStartingPoints;
	int _numSimulations;
	MDOUBLE _upperBoundMuVals; // by default 5; testing shows that this values does not change the likelihood by much
	MDOUBLE _likelihoodGivenOptimizedParams;
	MDOUBLE _exp01;// expectation of number of changes from 0 to 1.. and so on:
	MDOUBLE _exp10;
	MDOUBLE _exp02;
	MDOUBLE _exp12;
	MDOUBLE _exp20;
	MDOUBLE _exp21;
	VVVdouble *_probChanges; // for each node, the posterior probability of a change from one state to another state
	VVdouble _ancestralProbs;

};


#endif // ___LGT_3STATE____H
