#include "unObservableData.h"
#include "likelihoodComputation.h"
#include "likelihoodComputationGL.h"
#include <math.h>


using namespace std;

unObservableData::unObservableData(const sequenceContainer& sc,const stochasticProcess* sp ,const gainLossAlphabet alph)
{
	_scZero.startZeroSequenceContainerGL(sc,alph);
	_LforMissingDataPerCat.resize(sp->categories());
}
unObservableData::unObservableData(const unObservableData& other){
	_scZero = other._scZero;
	_pi = other._pi;
	_logLforMissingData = other._logLforMissingData;
	_LforMissingDataPerCat = other._LforMissingDataPerCat;
}
Vdouble* unObservableData::getpLforMissingDataPerCat(){return &_LforMissingDataPerCat;}
Vdouble unObservableData::getLforMissingDataPerCat(){return _LforMissingDataPerCat;}
MDOUBLE unObservableData::getlogLforMissingData(){return _logLforMissingData;}

void unObservableData::setLforMissingData(const tree& _tr, const stochasticProcess* _sp){
	_pi.fillPij(_tr,*_sp);
// NOTE: The "perCat" is out
	_LforMissingDataPerCat = likelihoodComputation::getLofPosPerCat(0,_tr,_scZero,_pi,*_sp);	// L * sp.ratesProb(i)
	_logLforMissingData = 0;
	for (int i=0; i < _sp->categories();++i) {
		_logLforMissingData += _LforMissingDataPerCat[i];
	}
	_logLforMissingData = log(_logLforMissingData);
}
void unObservableData::setLforMissingData(const tree& _tr, const vector<vector<stochasticProcess*> >& spVVec,	
						const distribution* distGain, const distribution* distLoss)
{
	_logLforMissingData = likelihoodComputationGL::getTreeLikelihoodAllPosAlphTheSame(_tr,_scZero,spVVec,distGain,distLoss,NULL);
}

