// $Id: fromCountTableComponentToDistance.cpp 4471 2008-07-17 15:38:50Z cohenofi $

#include "fromCountTableComponentToDistanceGLfixRoot.h"
#include "likeDistGLfixRoot.h"
#include <cassert>

fromCountTableComponentToDistanceGLfixRoot::fromCountTableComponentToDistanceGLfixRoot(
		const vector<countTableComponentGam>& ctc,
		const stochasticProcess &sp,
		const MDOUBLE toll,
		const MDOUBLE brLenIntialGuess,
		MDOUBLE *plogLforMissingData) : _sp(sp), _ctc(ctc) {
	_distance =brLenIntialGuess ;//0.03;
	_toll = toll;
	_plogLforMissingData = plogLforMissingData;

}

void fromCountTableComponentToDistanceGLfixRoot::computeDistance() {
	MDOUBLE maxPairwiseDistance = 5.0; // The default
	likeDistGLfixRoot likeDist1(_sp,_toll,maxPairwiseDistance,_plogLforMissingData);
	MDOUBLE initGuess = _distance;
	_distance = likeDist1.giveDistance(_ctc,_likeDistance,initGuess);
	assert(_distance>=0);
}
