/*
  File autogenerated by gengetopt version 2.7
  generated with the following command:
  /cs/++/phd/ninio/gengetopt-2.7/src/gengetopt -icmdline.ggo 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  structural EM based Phylogony\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h         --help                       Print help and exit\n");
  printf("   -V         --version                    Print version and exit\n");
  printf("   -sSTRING   --sequence=STRING            Sequence file name (default='-')\n");
  printf("   -fSTRING   --format=STRING              sequence format: [phylip],clustal,molphy,mase,fasta (default='phylip')\n");
  printf("   -tSTRING   --tree=STRING                Tree file name\n");
  printf("   -I         --cin                        Get input sequence file from cin (default=off)\n");
  printf("   -oSTRING   --outputfile=STRING          Output tree file (default='-')\n");
  printf("   -vINT      --verbose=INT                Log report level (verbose) (default=0)\n");
  printf("   -lSTRING   --Logfile=STRING             Log file output name (default='-')\n");
  printf("   -aINT      --alphabet=INT               Alphabet Size (default=20)\n");
  printf("   -mSTRING   --model=STRING               model type: day,[jtt],rev,nucjc,aaJC,k2p (default='jtt')\n");
  printf("   -zFLOAT    --ratio=FLOAT                transition transversion ratio (default=2)\n");
  printf("   -pSTRING   --ACGprob=STRING             comma separated NA prior list for hky model- A,C,G (default='0.25,0.25,0.25')\n");
  printf("   -GFLOAT    --gamma=FLOAT                use gamma and set alpha (default=0.3)\n");
  printf("   -S         --no-SEMPHY                  Don't do SEMPHY step (default=off)\n");
  printf("   -g         --gaps                       Remove positions with gaps (default=off)\n");
  printf("   -n         --no-bbl                     Do not do best branch length step (default=on)\n");
  printf("   -e         --exact                      Compute exact counts (default=off)\n");
  printf("   -MINT      --max-semphy-iterations=INT  Max number of SEM iterations (default=100)\n");
  printf("   -bINT      --max-bbl-iterations=INT     Max number of BBL iterations (default=1000)\n");
  printf("   -N         --dont-use-NJ                Do not Use NJ to break start in REART (default=on)\n");
  printf("   -dFLOAT    --minimum-improvement=FLOAT  Minimum improvement (default=0.001)\n");
  printf("   -xFLOAT    --maxDistance=FLOAT          'infinity' distance for sequance pairs (default=2)\n");
  printf("   -rLONG     --seed=LONG                  Seed random number generator\n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}
#endif /* HAVE_STRDUP */

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->sequence_given = 0 ;
  args_info->format_given = 0 ;
  args_info->tree_given = 0 ;
  args_info->cin_given = 0 ;
  args_info->outputfile_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->Logfile_given = 0 ;
  args_info->alphabet_given = 0 ;
  args_info->model_given = 0 ;
  args_info->ratio_given = 0 ;
  args_info->ACGprob_given = 0 ;
  args_info->gamma_given = 0 ;
  args_info->no_SEMPHY_given = 0 ;
  args_info->gaps_given = 0 ;
  args_info->no_bbl_given = 0 ;
  args_info->exact_given = 0 ;
  args_info->max_semphy_iterations_given = 0 ;
  args_info->max_bbl_iterations_given = 0 ;
  args_info->dont_use_NJ_given = 0 ;
  args_info->minimum_improvement_given = 0 ;
  args_info->maxDistance_given = 0 ;
  args_info->seed_given = 0 ;
#define clear_args() { \
  args_info->sequence_arg = strdup("-") ;\
  args_info->format_arg = strdup("phylip") ;\
  args_info->tree_arg = NULL; \
  args_info->cin_flag = 0;\
  args_info->outputfile_arg = strdup("-") ;\
  args_info->verbose_arg = 0 ;\
  args_info->Logfile_arg = strdup("-") ;\
  args_info->alphabet_arg = 20 ;\
  args_info->model_arg = strdup("jtt") ;\
  args_info->ratio_arg = 2 ;\
  args_info->ACGprob_arg = strdup("0.25,0.25,0.25") ;\
  args_info->gamma_arg = 0.3 ;\
  args_info->no_SEMPHY_flag = 0;\
  args_info->gaps_flag = 0;\
  args_info->no_bbl_flag = 1;\
  args_info->exact_flag = 0;\
  args_info->max_semphy_iterations_arg = 100 ;\
  args_info->max_bbl_iterations_arg = 1000 ;\
  args_info->dont_use_NJ_flag = 1;\
  args_info->minimum_improvement_arg = 0.001 ;\
  args_info->maxDistance_arg = 2 ;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "sequence",	1, NULL, 's' },
        { "format",	1, NULL, 'f' },
        { "tree",	1, NULL, 't' },
        { "cin",	0, NULL, 'I' },
        { "outputfile",	1, NULL, 'o' },
        { "verbose",	1, NULL, 'v' },
        { "Logfile",	1, NULL, 'l' },
        { "alphabet",	1, NULL, 'a' },
        { "model",	1, NULL, 'm' },
        { "ratio",	1, NULL, 'z' },
        { "ACGprob",	1, NULL, 'p' },
        { "gamma",	1, NULL, 'G' },
        { "no-SEMPHY",	0, NULL, 'S' },
        { "gaps",	0, NULL, 'g' },
        { "no-bbl",	0, NULL, 'n' },
        { "exact",	0, NULL, 'e' },
        { "max-semphy-iterations",	1, NULL, 'M' },
        { "max-bbl-iterations",	1, NULL, 'b' },
        { "dont-use-NJ",	0, NULL, 'N' },
        { "minimum-improvement",	1, NULL, 'd' },
        { "maxDistance",	1, NULL, 'x' },
        { "seed",	1, NULL, 'r' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVs:f:t:Io:v:l:a:m:z:p:G:SgneM:b:Nd:x:r:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 's':	/* Sequence file name.  */
          if (args_info->sequence_given)
            {
              fprintf (stderr, "%s: `--sequence' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->sequence_given = 1;
          args_info->sequence_arg = strdup (optarg);
          break;

        case 'f':	/* sequence format: [phylip],clustal,molphy,mase,fasta.  */
          if (args_info->format_given)
            {
              fprintf (stderr, "%s: `--format' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->format_given = 1;
          args_info->format_arg = strdup (optarg);
          break;

        case 't':	/* Tree file name.  */
          if (args_info->tree_given)
            {
              fprintf (stderr, "%s: `--tree' (`-t') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->tree_given = 1;
          args_info->tree_arg = strdup (optarg);
          break;

        case 'I':	/* Get input sequence file from cin.  */
          if (args_info->cin_given)
            {
              fprintf (stderr, "%s: `--cin' (`-I') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->cin_given = 1;
          args_info->cin_flag = !(args_info->cin_flag);
          break;

        case 'o':	/* Output tree file.  */
          if (args_info->outputfile_given)
            {
              fprintf (stderr, "%s: `--outputfile' (`-o') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->outputfile_given = 1;
          args_info->outputfile_arg = strdup (optarg);
          break;

        case 'v':	/* Log report level (verbose).  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->verbose_given = 1;
          args_info->verbose_arg = atoi (optarg);
          break;

        case 'l':	/* Log file output name.  */
          if (args_info->Logfile_given)
            {
              fprintf (stderr, "%s: `--Logfile' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->Logfile_given = 1;
          args_info->Logfile_arg = strdup (optarg);
          break;

        case 'a':	/* Alphabet Size.  */
          if (args_info->alphabet_given)
            {
              fprintf (stderr, "%s: `--alphabet' (`-a') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->alphabet_given = 1;
          args_info->alphabet_arg = atoi (optarg);
          break;

        case 'm':	/* model type: day,[jtt],rev,nucjc,aaJC,k2p.  */
          if (args_info->model_given)
            {
              fprintf (stderr, "%s: `--model' (`-m') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->model_given = 1;
          args_info->model_arg = strdup (optarg);
          break;

        case 'z':	/* transition transversion ratio.  */
          if (args_info->ratio_given)
            {
              fprintf (stderr, "%s: `--ratio' (`-z') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->ratio_given = 1;
          args_info->ratio_arg = (float)strtod (optarg, NULL);
          break;

        case 'p':	/* comma separated NA prior list for hky model- A,C,G.  */
          if (args_info->ACGprob_given)
            {
              fprintf (stderr, "%s: `--ACGprob' (`-p') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->ACGprob_given = 1;
          args_info->ACGprob_arg = strdup (optarg);
          break;

        case 'G':	/* use gamma and set alpha.  */
          if (args_info->gamma_given)
            {
              fprintf (stderr, "%s: `--gamma' (`-G') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->gamma_given = 1;
          args_info->gamma_arg = (float)strtod (optarg, NULL);
          break;

        case 'S':	/* Don't do SEMPHY step.  */
          if (args_info->no_SEMPHY_given)
            {
              fprintf (stderr, "%s: `--no-SEMPHY' (`-S') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->no_SEMPHY_given = 1;
          args_info->no_SEMPHY_flag = !(args_info->no_SEMPHY_flag);
          break;

        case 'g':	/* Remove positions with gaps.  */
          if (args_info->gaps_given)
            {
              fprintf (stderr, "%s: `--gaps' (`-g') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->gaps_given = 1;
          args_info->gaps_flag = !(args_info->gaps_flag);
          break;

        case 'n':	/* Do not do best branch length step.  */
          if (args_info->no_bbl_given)
            {
              fprintf (stderr, "%s: `--no-bbl' (`-n') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->no_bbl_given = 1;
          args_info->no_bbl_flag = !(args_info->no_bbl_flag);
          break;

        case 'e':	/* Compute exact counts.  */
          if (args_info->exact_given)
            {
              fprintf (stderr, "%s: `--exact' (`-e') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->exact_given = 1;
          args_info->exact_flag = !(args_info->exact_flag);
          break;

        case 'M':	/* Max number of SEM iterations.  */
          if (args_info->max_semphy_iterations_given)
            {
              fprintf (stderr, "%s: `--max-semphy-iterations' (`-M') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->max_semphy_iterations_given = 1;
          args_info->max_semphy_iterations_arg = atoi (optarg);
          break;

        case 'b':	/* Max number of BBL iterations.  */
          if (args_info->max_bbl_iterations_given)
            {
              fprintf (stderr, "%s: `--max-bbl-iterations' (`-b') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->max_bbl_iterations_given = 1;
          args_info->max_bbl_iterations_arg = atoi (optarg);
          break;

        case 'N':	/* Do not Use NJ to break start in REART.  */
          if (args_info->dont_use_NJ_given)
            {
              fprintf (stderr, "%s: `--dont-use-NJ' (`-N') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->dont_use_NJ_given = 1;
          args_info->dont_use_NJ_flag = !(args_info->dont_use_NJ_flag);
          break;

        case 'd':	/* Minimum improvement.  */
          if (args_info->minimum_improvement_given)
            {
              fprintf (stderr, "%s: `--minimum-improvement' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->minimum_improvement_given = 1;
          args_info->minimum_improvement_arg = (float)strtod (optarg, NULL);
          break;

        case 'x':	/* 'infinity' distance for sequance pairs.  */
          if (args_info->maxDistance_given)
            {
              fprintf (stderr, "%s: `--maxDistance' (`-x') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->maxDistance_given = 1;
          args_info->maxDistance_arg = (float)strtod (optarg, NULL);
          break;

        case 'r':	/* Seed random number generator.  */
          if (args_info->seed_given)
            {
              fprintf (stderr, "%s: `--seed' (`-r') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->seed_given = 1;
          args_info->seed_arg = atol (optarg);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}
