#ifndef ___SIMULATE_RATES
#define ___SIMULATE_RATES

#include "McRate_Definitions.h"
#include "treeInterface.h"

using namespace treeInterface;

class stochasticProcess;
class alphabet;
class distribution;


/*
Simulate Rates: 
1. loads "real" rates distribution from a file into a vector = m_ratesDist.
2. chooses rates (from the distribution vector) randomly - these are the rates to be simulated.
3. get a tree and a root sequence
4. generates leaf sequences according to the chosen rates.
5. finds the mcmc estimate for that tree
6. calc the distance between the estimate and the real rates (the simulated rates)
7. do step 5+6 for the ML estimate    
*/
class SimulateRates  
{
public:

	enum SimType {FILE_DISTRIBUTION, FILE_FIXED, RANDOM, DISTRIBUTION};

	//SimulateRates(string treeFile, string ratesDistFile, 
	//	const stochasticProcess& sp, const alphabet* alph);
	
	explicit SimulateRates(const tree& in_tree, string ratesDistFile, int colNum, 
		const stochasticProcess& sp, const alphabet* palph);


	virtual ~SimulateRates();

	//void runSimulation(int seqLength);

	//print the result msa into file
	void generateSequencesToMsaFile(int seqLength, ofstream& outFile, SimType simulationType, distribution* pDist = NULL);
	//print also the rates
	void generateSequencesToMsaFile(int seqLength, ofstream& msaFile, ofstream& ratesFile, SimType simulationType, distribution* pDist = NULL);

	void generateSequencesToMsaFileFixedRates(int seqLength, ofstream& msaFile, ofstream& ratesFile, MDOUBLE max_simRate);


	Vdouble getSimulatedRates() {return m_simulateRates;}

private:
	//init the rates distribution vector
	void loadRatesDistributionFromFile(string ratesDistFile, int colNum);
	//fill the simulation rates vector 
	void fillRateVector(int seqLength, SimType simulationType, distribution* pDist = NULL, bool bScale=true);
	
	void fillRateVectorFixed(int seqLength, MDOUBLE max_rate, int repetition=5, bool bScale=false);

	void printSimulatedRates(ofstream& ratesFile);

private:
	tree m_tree;
	const stochasticProcess& m_sp;
	const alphabet* m_pAlph;
	Vdouble m_ratesDist; //the distribution of rates
	Vdouble m_simulateRates; //the chosen rates to simulate 
};

#endif 
