#ifndef ___RATE_PROBABILITY
#define ___RATE_PROBABILITY

#include "McRate_Definitions.h"

//class RateProb holds two values:
//1. the rate
//2. its probability
class RateProb  
{
public:

	explicit RateProb() {m_rate = 0; m_prob = 0;}
	explicit RateProb(const MDOUBLE rate, const MDOUBLE p) {m_rate = rate; m_prob = p;}
	virtual ~RateProb() {};

	void setRate(const MDOUBLE val) {m_rate = val;}
	MDOUBLE getRate() const {return m_rate;}
	void setProb(const MDOUBLE p) {m_prob = p;}
	MDOUBLE getProb() const {return m_prob;}
	void setRateP(const MDOUBLE r, const MDOUBLE p) {m_rate = r; m_prob = p;}

	bool operator< (const RateProb& in) const {return m_rate < in.m_rate;}
	inline RateProb& operator=(const RateProb& other);

private:
	MDOUBLE m_rate;
	MDOUBLE m_prob;
};

inline RateProb& RateProb::operator=(const RateProb& other)
{
	m_rate = other.m_rate; 
	m_prob = other.m_prob;
	return *this;
}

#endif //___RATE_PROBABILITY