#include "ProposeNNI.h"
#include "errorMsg.h"
#include "talRandom.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ProposeNNI::ProposeNNI()
{
}


ProposeNNI::~ProposeNNI()
{
}



MDOUBLE ProposeNNI::proposeNewState(tree& treeToChange, MDOUBLE& curAlpha, ParamProposal prop_type)
{
	MDOUBLE hastingsRatio = 1;
	vector<tree::nodeP> nodesVec;
	treeToChange.getAllNodes(nodesVec, treeToChange.iRoot());
	tree::nodeP tmpNode;
	do 
	{
		int i = talRandom::giveIntRandomNumberBetweenZeroAndEntry(nodesVec.size());
		tmpNode = nodesVec[i];
	}
	while (isLeaf(tmpNode) || tmpNode->isRoot()); // We have a root or an internal node

	if (tmpNode->father()->isRoot()) {
		// Topological change unique for root
		swapRoot(treeToChange, tmpNode);
	}
	else {
		// Topological change for internal edge.
		swapInternal(treeToChange, tmpNode);
	}
	return hastingsRatio;
}	

void ProposeNNI::updateParameters(MDOUBLE curAcceptanceRate)						  
{
	// Empty. Needs to be updated is the topological change is more complex
	// , e.g., includes branch lengths
}


void ProposeNNI::swapInternal(tree &treeToChange, tree::nodeP centerNode)
{
	tree::nodeP nodeToSwap1, nodeToSwap2;
	tree::nodeP fatherNode = centerNode->father();
	
	do 
	{
		int i = talRandom::giveIntRandomNumberBetweenZeroAndEntry(fatherNode->sons.size());
		nodeToSwap1 = fatherNode->sons[i];

	}
	while (nodeToSwap1 == centerNode); // in case the centerNode is chosen instead of its ancestor

	
	int sonN = talRandom::giveIntRandomNumberBetweenZeroAndEntry(centerNode->sons.size());
	nodeToSwap2 = centerNode->sons[sonN];
	
	
	treeToChange.removeNodeFromSonListOfItsFather(nodeToSwap1);
	nodeToSwap1->setFather(centerNode);
	centerNode->sons.push_back(nodeToSwap1);

	treeToChange.removeNodeFromSonListOfItsFather(nodeToSwap2);
	nodeToSwap2->setFather(fatherNode);
	fatherNode->sons.push_back(nodeToSwap2);
}




/*
void ProposeNNI::swapInternal(tree &treeToChange, tree::nodeP centerNode)
{
	tree::nodeP nodeToSwap1, nodeToSwap2;
	tree::nodeP fatherNode = centerNode->father();
	nodeToSwap1 = fatherNode->sons[0];
	// it might be the wrong node, i.e., centerNode and not the other son
	if (nodeToSwap1 == centerNode) 
	{
		nodeToSwap1 = fatherNode->sons[1];
	}
	
	if (talRandom::flipCoin()) {
		nodeToSwap2 = centerNode->sons[0];
	}
	else 	{
		nodeToSwap2 = centerNode->sons[1];
	}
	
	treeToChange.removeNodeFromSonListOfItsFather(nodeToSwap1);
	nodeToSwap1->setFather(centerNode);
	centerNode->sons.push_back(nodeToSwap1);

	treeToChange.removeNodeFromSonListOfItsFather(nodeToSwap2);
	nodeToSwap2->setFather(fatherNode);
	fatherNode->sons.push_back(nodeToSwap2);
}
*/

void ProposeNNI::swapRoot(tree &treeToChange, tree::nodeP myNode)
{
	//treeToChange.rootAt(myNode);
	swapInternal(treeToChange, myNode);	
	rootToUnrootedTree(treeToChange);
	

}



/*
tree NNI::NNIswap1(tree et,tree::nodeP mynode) {
	tree::nodeP mynodeInNewTree = findNodeByName(et,mynode->name());
#ifdef VERBOS
	cerr<<"b4 swap1"<<endl;
	et.output(cerr);i
#endif

	tree::nodeP fatherNode = mynodeInNewTree->father();
	tree::nodeP nodeToSwap1 = mynodeInNewTree->father()->sons[0];
	// it might be me
	if (nodeToSwap1 == mynodeInNewTree) nodeToSwap1 = mynodeInNewTree->father()->sons[1];
	tree::nodeP nodeToSwap2 = mynodeInNewTree->sons[0];

	et.removeNodeFromSonListOfItsFather(nodeToSwap1);
	et.removeNodeFromSonListOfItsFather(nodeToSwap2);
	nodeToSwap2->setFather(fatherNode);
	fatherNode->sons.push_back(nodeToSwap2);
	nodeToSwap1->setFather(mynodeInNewTree);
	mynodeInNewTree->sons.push_back(nodeToSwap1);
#ifdef VERBOS
	cerr<<"after swap1"<<endl;
	et.output(cerr);
#endif
	
	return et;
}

tree NNI::NNIswap2(tree et,tree::nodeP mynode) {
#ifdef VERBOS
	cerr<<"b4 swap2"<<endl;
	et.output(cerr);
#endif
	tree::nodeP mynodeInNewTree = findNodeByName(et,mynode->name());


	tree::nodeP fatherNode = mynodeInNewTree->father();
	tree::nodeP nodeToSwap1 = mynodeInNewTree->father()->sons[0];
	// it might be me
	if (nodeToSwap1 == mynodeInNewTree) nodeToSwap1 = mynodeInNewTree->father()->sons[1];
	tree::nodeP nodeToSwap2 = mynodeInNewTree->sons[1];
	et.removeNodeFromSonListOfItsFather(nodeToSwap1);
	et.removeNodeFromSonListOfItsFather(nodeToSwap2);
	nodeToSwap2->setFather(fatherNode);
	fatherNode->sons.push_back(nodeToSwap2);
	nodeToSwap1->setFather(mynodeInNewTree);
	mynodeInNewTree->sons.push_back(nodeToSwap1);
#ifdef VERBOS
	cerr<<"after swap2"<<endl;
	et.output(cerr);
#endif //VERBOS
	return et;

}

*/
