// ProposeGlobalBranch.cpp: implementation of the ProposeGlobalBranch class.
//
//////////////////////////////////////////////////////////////////////

#include "ProposeGlobalBranch.h"
#include "talRandom.h"



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ProposeGlobalBranch::ProposeGlobalBranch()
: Proposal()
{
	m_lambda = 0.1; 
}

ProposeGlobalBranch::~ProposeGlobalBranch()
{

}

MDOUBLE ProposeGlobalBranch::proposeNewState(tree& treeToChange, MDOUBLE& curAlpha, ParamProposal prop_type)
{
	MDOUBLE newDist, oneHastings, hastingsRatio = 1;
	vector<tree::nodeP> nodesVec;
	treeToChange.getAllNodes(nodesVec, treeToChange.iRoot());
	for (int i=0; i<nodesVec.size(); ++i)
	{
		if (nodesVec[i]->father() != NULL)
		{
			newDist = proposeNewDist(nodesVec[i]->dis2father(), oneHastings, prop_type, 0, MAX_BRANCH);
			nodesVec[i]->setDisToFather(newDist);
			hastingsRatio *= oneHastings;
		}
	}
	return hastingsRatio;
}

void ProposeGlobalBranch::updateParameters(MDOUBLE curAcceptanceRate)
{
	if (curAcceptanceRate < m_lowerAcceptance) 
	{
		// Lower lambda in order to increase acceptance rate 
		// Multiply lambda by number from 0.5 to 1
		MDOUBLE multiplier = 1 - talRandom::giveRandomNumberBetweenZeroAndEntry(0.5);
		m_lambda *= multiplier;
	}
	else if (curAcceptanceRate > m_upperAcceptance) 
	{
		// Increase lambda in order to lower acceptance rate
		// Multiply lambda by number from 1 to 2
		MDOUBLE multiplier = 1 + talRandom::giveRandomNumberBetweenZeroAndEntry(1);
		m_lambda *= multiplier;
		if (m_lambda > MAX_GLOBAL_LAMBDA)
			m_lambda = MAX_GLOBAL_LAMBDA;

	}
}

