// ProposeAlpha.cpp: implementation of the ProposeAlpha class.
//
//////////////////////////////////////////////////////////////////////

#include "ProposeAlpha.h"
#include "errorMsg.h"
#include "talRandom.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ProposeAlpha::ProposeAlpha()
{
	m_lambda = 0.1;
}

ProposeAlpha::~ProposeAlpha()
{
}


//proposeNewState: change alphaToChange according to the proposal type. 
//returns the Hastings ratio
MDOUBLE ProposeAlpha::proposeNewState(tree& curTree, MDOUBLE& alphaToChange, ParamProposal prop_type)
{
	MDOUBLE hastings = 1.0;
	alphaToChange = proposeNewDist(alphaToChange, hastings, prop_type, MIN_ALPHA, MAX_ALPHA);
	return hastings;
}

void ProposeAlpha::updateParameters(MDOUBLE curAcceptanceRate)
{
	if (curAcceptanceRate < m_lowerAcceptance) 
	{
		// Lower lambda in order to increase acceptance rate 
		// Multiply lambda by number from 0.5 to 1
		MDOUBLE multiplier = 1 - talRandom::giveRandomNumberBetweenZeroAndEntry(0.5);
		m_lambda *= multiplier;
	}
	else if (curAcceptanceRate > m_upperAcceptance) 
	{
		// Increase lambda in order to lower acceptance rate
		// Multiply lambda by number from 1 to 2
		MDOUBLE multiplier = 1 + talRandom::giveRandomNumberBetweenZeroAndEntry(1);
		m_lambda *= multiplier;
		if (m_lambda > MAX_ALPHA_LAMBDA)
			m_lambda = MAX_ALPHA_LAMBDA;
	}
}
