#ifndef ___PROPOSAL
#define ___PROPOSAL
#ifndef unix
#pragma warning (disable:4786)
#endif

#include "McRate_Definitions.h"

#include "treeInterface.h"

using namespace treeInterface;

class Proposal  
{
public:
	enum ParamProposal {LOG_UNIFORM, UNIFORM, MULTIPLY};

public:
	Proposal(MDOUBLE lowerAcceptance = 0.2, MDOUBLE upperAcceptance = 0.7);
	virtual ~Proposal();

	//proposeNewTree: propose a new tree. The returned value is HASTINGS ratio
	virtual MDOUBLE proposeNewState(tree& treeToChange, MDOUBLE& curAlpha, ParamProposal prop_type) = 0;
	//updateParameters: update the proposal parameters according to the current acceptance rate. should be used only during BURN-IN
	virtual void updateParameters(MDOUBLE curAcceptanceRate) = 0;

protected:
	virtual MDOUBLE proposeNewDist(const MDOUBLE curDist, MDOUBLE& hastings, ParamProposal prop_type, const MDOUBLE minDist, const MDOUBLE maxDist);

protected:
	MDOUBLE m_lowerAcceptance;
	MDOUBLE m_upperAcceptance;
	MDOUBLE m_lambda;

private:
	friend class Chain;

};

#endif // Proposal
