#include "Proposal.h"
#include "errorMsg.h"
#include "talRandom.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Proposal::Proposal(MDOUBLE lowerAcceptance, MDOUBLE upperAcceptance)
{
	if (upperAcceptance <= lowerAcceptance) 
	{
		errorMsg::reportError("lowerAcceptance is bigger than upperAcceptance in function Propsal::Propsal");
	}
	m_lowerAcceptance = lowerAcceptance;
	m_upperAcceptance = upperAcceptance;
}

Proposal::~Proposal()
{

}


// Changes the distance according to a log uniform proposal, 
// Hastings is the ratio between newDist and dist
MDOUBLE Proposal::proposeNewDist(const MDOUBLE curDist, MDOUBLE& hastings, ParamProposal prop_type, const MDOUBLE minDist, const MDOUBLE maxDist)
{
	MDOUBLE newDist;	
	switch (prop_type)
	{
	case LOG_UNIFORM:
		{
		MDOUBLE u = talRandom::giveRandomNumberBetweenZeroAndEntry(1);
		newDist = curDist * exp(m_lambda * (u - 0.5));
		hastings = newDist / curDist;
		}
		break;
	
	case UNIFORM:
		{
		MDOUBLE epsilon = talRandom::giveRandomNumberBetweenZeroAndEntry(m_lambda);
		if (talRandom::flipCoin()) 
			newDist = curDist + epsilon;
		else 
			newDist = curDist - epsilon;

		hastings = 1.0;
		}
		break;
	case MULTIPLY:
		{
		MDOUBLE u = talRandom::giveRandomNumberBetweenTwoPoints(1.0, 1.0 + m_lambda);
		if (talRandom::flipCoin()) 
			newDist = curDist * u;
		else 
			newDist = curDist / u;

		hastings = 1.0;
		}
		break;
	default:
		errorMsg::reportError("umknown proposal type in Proposal::proposeNewState()");
	}

	if (newDist > maxDist)
		newDist = maxDist - (newDist - maxDist);
	if (newDist < minDist)
		newDist = minDist + (minDist - newDist);
	if (newDist == 0)
		newDist = ZERO_DIST;
	////@@debug
	if (newDist < 0.0)
		cout << "negative distance!!!!! = "<<newDist<<endl; 
	return newDist;
}