#ifndef ___POSTERIOR_R4S
#define ___POSTERIOR_R4S
#ifndef unix
#pragma warning (disable:4786)
#endif

#include <vector>
using namespace std;



#include "definitions.h"
#include "treeInterface.h"
#include "sequenceContainer1G.h"


class stochasticProcess;
class alphabet;
class distribution;
class gammaDistribution;


using namespace std;
using namespace treeInterface;

class PosteriorR4s  
{
public:

	enum distType {GAMMA, UNIFORM};
	
	PosteriorR4s::PosteriorR4s(const tree& inTree, const alphabet* pAlph, 
						   const sequenceContainer1G & seqContainer, 
						   const stochasticProcess* pSp);

	virtual ~PosteriorR4s();

	Vdouble findRates(bool bScaleRates, const int categories, bool allStat);
	Vdouble findRates(bool bScaleRates, MDOUBLE alpha, const int categories, bool allStat);

	void printRates(ofstream& outFile);

	
	//void plotRate4site(ofstream& outFile, const MDOUBLE maxRate, const int numCategories, distType priorDist, MDOUBLE alpha);
	
	MDOUBLE getAlpha();

	Vdouble getMapRates() {return m_mapRates;}
	Vdouble getRates() {return m_expRates;}
	Vdouble getStdVec() {return m_stdVec;}
	Vdouble get25Vec() {return m_25Vec;}
	Vdouble get75Vec() {return m_75Vec;}

private:
	//compute r4s for the whole sequence
	void computeRate4site(const int numCategories, bool bAllStat);

	//compute r4s for a specific position
	MDOUBLE computeRate4site(int position, MDOUBLE &stdOut);

	void computeLVec(const int pos, const int fromCategory, const int toCategory, const distribution* dist, Vdouble& LVec);

	//clear vecotrs before computeRate4site()
	void clearDS(bool bAllStat);

	//claculate statistics for each site: MAP, 25+75 percentiles
	void calcStat(const int numCategories, MDOUBLE scaleFactor);


private:
	//options
	const alphabet* m_pAlph;
	tree m_tree;
	sequenceContainer1G m_seqContainer;
	const stochasticProcess* m_pSp;
	const distribution* m_pPriorDist;
	
	Vdouble m_expRates; //the result expectation rates
	Vdouble m_mapRates; //the result MAP (maximum posterior) rates
	Vdouble m_stdVec; //each position corresponds to the std of that site. 

	VVdouble m_rateDist; //a vector for each position. each entry is a vector of rates probabilities:rateDist[i][j] = P(Rj) in position i.
	Vdouble m_25Vec; //holds the 25 percentile rate for each position
	Vdouble m_75Vec; //holds the 75 percentile rate for each position
};

#endif 
