#ifndef __MULTICHAIN
#define __MULTICHAIN
#ifndef unix
#pragma warning (disable:4786)
#endif

#include <vector>
#include <fstream>
using namespace std;

#include "Chain.h"
#include "McRateOptions.h"

/*
class multiChainParameters 
{
private:
	friend class MultiChain;
	friend class McRate;
	explicit multiChainParameters();
	int m_kThinning;// default = 10
	bool m_bScale; // default = true;
	int m_minSteps; // default= 1000
	int m_stepsInLimit; // default= 20; // stopping the chains criterions
	MDOUBLE m_rLimit;// default = -1;
	MDOUBLE m_epsilonLimit; //default= 0.01;// stopping the chains criterions
	int m_calibrationCycle;// default= 100;
	int m_alternateSteps;// default= 100;
	bool m_bInferRates; //default = true;
	bool m_bDoCorrelationTest; //default = false;
};
*/

class MultiChain  
{
public:

	explicit MultiChain(const int chainsNum,
						const sequenceContainer1G & sc,
						const stochasticProcess* pSp, 
						const string resBaseFileStr,
						const McRateOptions & options);

	//if tree is given - , then if it is with branch length - this is the starting tree.
	//otherwise - it is the starting topology and branch lengths are randomized.
	explicit MultiChain(const tree& t1,
						const int chainsNum,
						const sequenceContainer1G & sc,
						const stochasticProcess* pSp, 
						const string resBaseFileStr,
						const McRateOptions & options); 
	virtual ~MultiChain();

	void runChains(const int burnInTime, const int maxInferrenceTime);

	void printResults(ofstream& outFile);

	//getBayesTreeAllChains: returns the average tree from all chains 
	void getBayesTreeAllChains(tree& bayesTree, const bool bTopology);

	Vdouble getAverageRatesAllChains();

	//getAlphaAllChains: returns the average alpha from all chains 
	MDOUBLE getAverageAlphaOverAllChains() const;

private:
	//runBurnIn - run burnin steps. 
	void runBurnIn(const int burnInTime);
	void runInference(const int maxInferrenceTime);
	//decide how many inference steps each chain should next do
	int computeHowManyInferenceStepsToDo(const int stepsDone, const int maxInferrenceTime);

	//convergence tests
	//IsChainsLimit: check if chains have converged to a limit value
	bool IsChainsLimit(const int stepNum);
	//isEnoughInferenceSteps: return true if the all chains have perfomed a minimum number of steps before convergence can be reached
	bool isEnoughInferenceSteps(const int stepsDone);
	//correlationTest: return true if the correlations between all of the rates chains is higher than some value
	bool correlationTest();
	//checkIfRatesOfChainsConverged: return true if the average rates from all chains doesn't change (much) anymore
	bool checkIfRatesOfChainsConverged(const int stepsDone);

	vector<string> getChainsFileNames(const int chainsNum, const string& baseFolderName);
	int numChains() const {return m_pChainsVec.size();}

private:
	vector<Chain*> m_pChainsVec;
	const McRateOptions & m_options;
	ofstream m_resFile;

};

#endif // __MULTICHAIN
