#include "McRateOptions.h"

#include "errorMsg.h"
#include "someUtil.h"
#include <iostream>
using namespace std;

//when making changes - make sure to make changes also in copy constructor
McRateOptions::McRateOptions(int& argc, char *argv[]):
//DEFAULTS VALUES: 
m_treefileStr(""),
m_seqFileStr(""),
m_logFileStr(""),
m_outDirStr("McRateRes//"),
m_referenceSeq("none"),
m_logValue(3), // log file format information (for debuggin only)
m_seqInputFormat(MASE),
m_modelName(JTT),
m_alphabet_size(20), 
m_bRemoveGaps(false), // default gaps = missing data.
m_pOutPtr(&cout),
m_numCategories(16),
m_chainsNum(1),
m_calibrationCycle(100),
m_thinning(10),
m_burningTime(10000),
m_inferenceTime(100000),
m_bStopChainsIfRateConverged(false),
m_bDoCorrelationTest(false),
m_minSteps(1000),
m_epsilonLimit(0.01),
m_stepsInLimit(300),
m_rLimit(0.9),
m_alternateSteps(100),
m_bScale(true),
m_bInferRates(true)
{
	readOptions(argc, argv);
	
	//open output file
	createDir("", m_outDirStr);
	string resFileStr = m_outDirStr + string("mcRate4Site.txt"); 
	m_outFile.open(resFileStr.c_str()); 
	m_pOutPtr= &m_outFile; 

}

McRateOptions::McRateOptions(const McRateOptions &other):
m_treefileStr(other.m_treefileStr),
m_seqFileStr(other.m_seqFileStr),
m_logFileStr(other.m_logFileStr),
m_outDirStr(other.m_outDirStr),
m_referenceSeq(other.m_referenceSeq),
m_logValue(other.m_logValue), // log file format information (for debuggin only)
m_seqInputFormat(other.m_seqInputFormat),
m_modelName(other.m_modelName),
m_alphabet_size(other.m_alphabet_size), 
m_bRemoveGaps(other.m_bRemoveGaps), // default gaps = missing data.
m_numCategories(other.m_numCategories),
m_chainsNum(other.m_chainsNum),
m_calibrationCycle(other.m_calibrationCycle),
m_thinning(other.m_thinning),
m_burningTime(other.m_burningTime),
m_inferenceTime(other.m_inferenceTime),
m_bStopChainsIfRateConverged(other.m_bStopChainsIfRateConverged),
m_bDoCorrelationTest(other.m_bDoCorrelationTest),
m_minSteps(other.m_minSteps),
m_epsilonLimit(other.m_epsilonLimit),
m_stepsInLimit(other.m_stepsInLimit),
m_rLimit(other.m_rLimit),
m_alternateSteps(other.m_alternateSteps),
m_bScale(other.m_bScale),
m_bInferRates(other.m_bInferRates)
{
	string resFileStr = m_outDirStr + string("mcRate4Site.txt"); 
	m_outFile.open(resFileStr.c_str()); 
	m_pOutPtr= &m_outFile; 
}

McRateOptions::~McRateOptions()
{
}

void McRateOptions::readOptions(int& argc, char *argv[])
{	
	int option_index = 0;
	int c = 0;

	while (c >= 0) 
	{
		
#ifdef WIN32
		c = getopt_long(argc, argv,"A:a:b:B:c:C:e:E:gGi:I:k:K:m:M:n:N:p:P:T:t:s:S:O:o:l:L:u:U:v:V:Q:q:DJRC:djrc:Hh?",NULL,&option_index);
#else
		c = getopt(argc, argv,"A:a:b:B:c:C:e:E:gGi:I:k:K:m:M:n:N:pPT:t:s:S:O:o:l:L:v:V:u:U:Q:q:DJRC:djrc:Hh?");
#endif
	
		switch (c) 
		{
		case 'a': case 'A':
			m_referenceSeq = optarg;
			break;
		case 'g': case 'G': 
			m_bRemoveGaps = true; 
			break;
		case 'h': case 'H': case '?':
			printHelp(argv);
		case 'l': case 'L': 
			m_logFileStr = optarg;
			break;
		case 'm': case 'M':
			getModelName();
			break;
		case 'q': case 'Q':	
			getSeqInputFormat();
			break; 
		case 's': case 'S': 
			m_seqFileStr = optarg;
			break;
		case 't': case 'T': 
			m_treefileStr = optarg;
			break;
		case 'v': case 'V': 
			m_logValue = atoi(optarg); 
			break;
		case 'k': case 'K': 
			m_numCategories = atoi(optarg); 
			break;
		case 'n': case 'N': 
			m_chainsNum = atoi(optarg); 
			break;
		case 'c': case 'C': 
			m_calibrationCycle = atoi(optarg); 
			break;
		case 'e': case 'E': 
			m_thinning = atoi(optarg); 
			break;
		case 'i': case 'I': 
			m_inferenceTime = atoi(optarg); 
			break;
		case 'b': case 'B': 
			m_burningTime = atoi(optarg); 
			break;
		case 'P': case 'p': 
			m_bStopChainsIfRateConverged = true;
			break;
		case 'O': case 'o':
			string baseResultsDir = optarg;
			//createDir(baseResultsDir, m_outDirStr);
			m_outDirStr = baseResultsDir + string("//") + m_outDirStr;
			break;

		} //end of switch
	} //end of while
}


void McRateOptions::getModelName()
{
	switch (optarg[0]) 
	{
	case 'd': case 'D':
		m_modelName = DAY;
		m_alphabet_size=20; 
		break;
	case 'j': case 'J':
		m_modelName = JTT;
		m_alphabet_size = 20;
		break;
	case 'r': case 'R':  
		m_modelName = REV;
		m_alphabet_size = 20;
		break;
	case 'w': case 'W':  
		m_modelName = WAG;
		m_alphabet_size = 20;
		break;
	case 'c': case 'C':  
		m_modelName = CPREV;
		m_alphabet_size = 20;
		break;
	case 'a': case 'A':  
		m_modelName = AAJC;
		m_alphabet_size = 20;
		break;
	case 'n': case 'N':  
		m_modelName= NUCJC;
		m_alphabet_size = 4;
		break;
	default:
		m_modelName = JTT;
		m_alphabet_size = 20;
		break;
	}
}

void McRateOptions::getSeqInputFormat()
{
	switch (optarg[0]) 
	{
	case 'C': case 'c':  
		m_seqInputFormat = CLUSTAL;
		break;
	case 'F': case 'f':  
		m_seqInputFormat = FASTA;
		break;
	case 'P': case 'p':  
		m_seqInputFormat = PHYLIP;
		break;
	case 'M': case 'm': 
		switch (optarg[1])
		{
		case 'o': case 'O': 
			m_seqInputFormat = MOLPHY;
			break;
		default:
			m_seqInputFormat = MASE;
			break;
		}
	break;
	default:
			m_seqInputFormat = MASE;
			break;
	} // end of optarg[0]
}


void McRateOptions::getChainParam()
{
	switch (optarg[0]) 
	{
	case 'C': case 'c':  
		m_calibrationCycle = CLUSTAL;
		break;
	case 'F': case 'f':  
		m_seqInputFormat = FASTA;
		break;
	case 'P': case 'p':  
		m_seqInputFormat = PHYLIP;
		break;
	default:
			m_seqInputFormat = MASE;
			break;
	} // end of optarg[0]
}
void McRateOptions::printHelp(char *argv[])
{
	cout <<"USAGE:	"<<argv[0]<<" [-options] "<<endl <<endl;
	cout <<"|/-------------------- +-----------------------+"<<endl;
	cout <<"|-t    tree file       |-Q    input seq format |"<<endl;
	cout <<"|-s    seq file        |-Qc   Clustal          |"<<endl;
	cout <<"|-l    log file        |-Qf   Fasta            |"<<endl;
	cout <<"|-v    log value       |-Qm   Mase             |"<<endl;
	cout <<"|                      |-Qmo  Molphy           |"<<endl;
	cout <<"|                      |-Qp   Phylip           |"<<endl;
	cout <<"|/-------------------- +-----------------------+"<<endl;
	cout <<"|-M     model name                             |"<<endl;
	cout <<"|-Mj    JTT                                    |"<<endl;
	cout <<"|-Mr    REV (for mitochondrial genomes)        |"<<endl;
	cout <<"|-Md    DAY                                    |"<<endl;
	cout <<"|-Mw    WAG                                    |"<<endl;
	cout <<"|-MC    cpREV (for chloroplasts genomes)       |"<<endl;
	cout <<"|-Ma    JC amino acids                         |"<<endl;
	cout <<"|-Mn    JC nucleotides                         |"<<endl;
	cout <<"|-Mn    JC nucleotides                         |"<<endl;
	cout <<"|----------------------------------------------|"<<endl;
	cout <<"|-Kxx number of discrete categories            |"<<endl;
	cout <<"| default: 16								   |"<<endl;
	cout <<"|-Nxx number of chains                         |"<<endl;
	cout <<"| default: 1								   |"<<endl;
	cout <<"|-Cxx calibarate chain every xxth step         |"<<endl;
	cout <<"| default: 100								   |"<<endl;
	cout <<"|-Exx thinning param						   |"<<endl;
	cout <<"| default: 10								   |"<<endl;
	cout <<"|----------------------------------------------|"<<endl;
	cout <<"|-Bxx Burning time = xx			               |"<<endl;
	cout <<"| default: 10000							   |"<<endl;
	cout <<"|-Ixx Inference time = xx			           |"<<endl;
	cout <<"| default: 100000							   |"<<endl;
	cout <<"|-P stop chains if rates have converged        |"<<endl;
	cout <<"|default: chains are run <inferenc time> steps |"<<endl;
	cout <<"|----------------------------------------------|"<<endl;
	cout <<"|-G remove positions with gaps                 |"<<endl;
	cout <<"|default: gaps are treated as missing data     |"<<endl;
	cout <<"|----------------------------------------------|"<<endl;
	cout <<"|-h or -? or -H     help                       |"<<endl;
	cout <<"|capital and no captial letters are ok         |"<<endl;
	cout <<"+----------------------+-----------------------+"<<endl;
	cout<<endl;	

	cerr<<" please press 0 to exit "; 
	int d; 
	cin>>d;
	exit (0);
}