#ifndef ___McRATE
#define ___McRATE
#ifndef unix
#pragma warning (disable:4786)
#endif


#include "McRateOptions.h"
#include "MultiChain.h"


#include "treeInterface.h"
using namespace treeInterface;
#include "sequenceContainer1G.h"
#include "stochasticProcess.h"

class McRate 
{
public:
	explicit McRate(int argc, char* argv[]);
	explicit McRate(McRateOptions &options);

	virtual ~McRate();
	void run();

	Vdouble getRates() const {return m_pMultiChain->getAverageRatesAllChains();}
	void getAvgTree(tree& bayesTree, bool bTopology) const {m_pMultiChain->getBayesTreeAllChains(bayesTree, bTopology);} 
	MDOUBLE getAverageAlpha() const {return m_pMultiChain->getAverageAlphaOverAllChains();}

private:
	void printRunInfo(ostream& out);
	void printOptionParameters();
	void getStartingSequenceData();
	void getStartingStochasticProcess();
	void getStartingEvolTree();
	void getStartingTreeFromTreeFile();
	//multiChainParameters getChainsParam();
	void computeRate4Site();
	//compute the number of sequences in each position
	void computeData4Pos();
	void printRates();


	
	McRateOptions getOptions() const {return m_options;}
private:

	McRateOptions m_options;
	MultiChain*	m_pMultiChain;
	sequenceContainer1G m_seqContainer;
	tree m_tree;
	stochasticProcess* m_pSp;
	alphabet* m_pAlph;
	

	Vdouble m_rate4site;
	Vdouble m_seqNum4pos; //each entry is the number of sequences in the position (i.e., without gaps)

};


#endif
