#ifndef unix
#pragma warning (disable:4786)
#endif

#include <string>
#include <fstream>
#include <iostream>
using namespace std;

#include "McRate_Definitions.h"
#include "McRateOptions.h"
#include "SimulateRates.h"
#include "McRateUtils.h"
#include "PosteriorR4s.h"
#include "McRate.h"
using namespace McRateUtils;

#include "datMatrixHolder.h"
#include "readDatMatrix.h"
#include "likelihoodComputation.h"
#include "amino.h"
#include "uniDistribution.h"
#include "chebyshevAccelerator.h"
#include "gammaDistribution.h"
#include "stochasticProcess.h"
#include "sequenceContainer1G.h"
#include "maseFormat.h"
#include "brLenOptEM.h"
#include "someUtil.h"
#include "talRandom.h"
#include "distanceTable.h"
#include "likeDist.h"
#include "nj.h"


string dirMSA;
string dirSimRates;

string createOutputDirectories() 
{
	createDir("Runs","Nov17_1.0Alpha_6Tree");
	string resultsFolder = "Runs//" + string("Nov17_1.0Alpha_6Tree");
	createDir(resultsFolder, "msa");
	dirMSA = resultsFolder + string("//msa");
	createDir(resultsFolder, "simRates");
	dirSimRates = resultsFolder + string("//simRates");
	createDir(resultsFolder, "BayesRates");
	string dirMCMCRates = resultsFolder + string("//MCMC");
	return resultsFolder;
}


Vdouble produceSimulationRatesAndMSA(int seqLen, MDOUBLE model_alpha, 
									 tree& model_tree, stochasticProcess* pSp,
									 alphabet* pAlph, string simSeqFileStr, 
									 string simRatesFileStr)
{
	string ratesFile = "Rates\\500_SH2_34_forSimulationBayes.txt";
	gammaDistribution gDist(model_alpha, 24);
	ofstream simSeqFile(simSeqFileStr.c_str());
	ofstream simRatesFile(simRatesFileStr.c_str());
	SimulateRates sim(model_tree, ratesFile, 2, *pSp, pAlph);
	sim.generateSequencesToMsaFile(seqLen, simSeqFile, simRatesFile, SimulateRates::DISTRIBUTION, &gDist); 
	simSeqFile.close();
	simRatesFile.close();
	return sim.getSimulatedRates();
}

tree getNJtree(sequenceContainer1G & sc, stochasticProcess* pSp)
{
	likeDist pd1(20, *pSp, 0.01);
	VVdouble disTab;
	vector<string> vNames;
	giveDistanceTable(&pd1, sc, disTab, vNames);
	NJalg nj1;
	return (nj1.computeNJtree(disTab,vNames));

}

int main(int argc, char* argv[]) 
{
	printTime(cerr);
	talRandom::setSeed(2);
	string baseFolder = createOutputDirectories();
	string simMsaFileStr = dirMSA + string("//") + string("simulateMSA.txt");
	string simRatesFileStr = dirSimRates + string("//") + string("_simR4s.txt");
	
	alphabet* pAlph = new amino;
	replacementModel *pProbMod = new pupAll(datMatrixHolder::jones);
	distribution *pDist = new gammaDistribution(1.0, GAMMA_CATEGORIES); 
	pijAccelerator * pPijAcc = new chebyshevAccelerator(pProbMod);
	stochasticProcess* pSp = new stochasticProcess(pDist, pPijAcc);

	
	//////////////////////////////////
	McRateOptions options(argc, argv);
	int seqLen = 150;
	MDOUBLE model_alpha = 1.0;
	tree model_tree(options.getTreeFileStr());
	///////////////////////////////////////////////////////////

	Vdouble simRates = produceSimulationRatesAndMSA(seqLen, model_alpha, model_tree, 
													pSp, pAlph, simMsaFileStr, simRatesFileStr);

	//infer mcmc
	//McRate mcmcRates(argc, argv);
	McRate mcmcRates(options);
/*	tree bayesTree;
	mcmcRates.getAvgTree(bayesTree, false);	
	cerr <<"average alpha is:  " <<mcmcRates.getAverageAlpha() <<endl;
	bayesTree.output(baseFolder + string("//") + string("allChainsTree.txt"));
*/
	ifstream seqFile(simMsaFileStr.c_str());
	sequenceContainer1G seqContainer = maseFormat::read(seqFile,pAlph);
	seqFile.close();




	/////////////////////////////////
	//ML Tree- infer rate4site with posterior 16 categories. 
	//The tree used for inference is the ML tree (branch lengths optimization only)
	tree NJtree = getNJtree(seqContainer, pSp);
	//MDOUBLE l = likelihoodComputation::getTreeLikelihoodAllPosAlphTheSame(MLtree, seqContainer, *pSp);
	//brLenOptEM::optimizeBranchLength1G_EM(MLtree, seqContainer, *pSp, NULL, 100,0.01);
	NJtree.output(baseFolder + string("//") + string("mlTree.txt"));
	PosteriorR4s njBayes(NJtree, pAlph, seqContainer, pSp);
	Vdouble njRates = njBayes.findRates(true, options.getCategoriesNum(), true);
	string NJOutFileStr = baseFolder + string("//") + string("NJTreeRates.txt");
	ofstream NJOutFile(NJOutFileStr.c_str());
	njBayes.printRates(NJOutFile);
	NJOutFile.close();

//	/////////////////////////////////
//	//BayesTree - infer rate4site with posterior 16 categories. 
//	//The tree used for inference is the mcmc tree (average branch lengths over the whole run)
//	PosteriorR4s mcBayes(bayesTree, pAlph, seqContainer, pSp);
//	Vdouble bayesRates = mcBayes.findRates(true, options.getCategoriesNum(), true);
//	string BayesTreeOutFileStr = baseFolder + string("//") + string("BayesTreeRates.txt");
//	ofstream BayesTreeOutFile(BayesTreeOutFileStr.c_str());
//	mcBayes.printRates(BayesTreeOutFile);
//	BayesTreeOutFile.close();

	/////////////////////////////////
	//modelTree - infer rate4site with posterior 16 categories. 
	//The tree used for inference is the same tree as the one used for the simulation (i.e., the true tree)
	PosteriorR4s modelBayes(model_tree, pAlph, seqContainer, pSp);
	Vdouble modelRates = modelBayes.findRates(true, model_alpha, options.getCategoriesNum(), true);
	string modelTreeOutFileStr = baseFolder + string("//") + string("modelTreeRates.txt");
	ofstream modelTreeOutFile(modelTreeOutFileStr.c_str());
	modelBayes.printRates(modelTreeOutFile);
	modelTreeOutFile.close();

	MDOUBLE model_cor = McRateUtils::calcCorrelationCoefficient(simRates, modelRates);	
	MDOUBLE mcmc_cor = McRateUtils::calcCorrelationCoefficient(simRates, mcmcRates.getRates());	
	MDOUBLE nj_cor = McRateUtils::calcCorrelationCoefficient(simRates, njRates);	
//	MDOUBLE bayes_cor = McRateUtils::calcCorrelationCoefficient(simRates, bayesRates);	


	int otu_num = seqContainer.numberOfSequences();
	string resFileStr = baseFolder + string("//comparison.txt");
	ofstream resFile(resFileStr.c_str());
	resFile<<"inference" <<"\t" <<"OTU_num"<<"\t" <<"alpha"<<"\t"<<"correlation"<<endl;
	resFile<<"model" <<"\t" << otu_num <<"\t" <<"\t"<<model_alpha<<"\t"<<model_cor<<endl;
	resFile<<"mcmc"  <<"\t" << otu_num <<"\t" <<mcmcRates.getAverageAlpha()<<"\t"<<mcmc_cor<<endl;
	resFile<<"NJ"  <<"\t" << otu_num <<"\t" <<njBayes.getAlpha()<<"\t"<<nj_cor<<endl;
	//resFile<<"bayes"  <<"\t" << otu_num <<"\t" <<mcBayes.getAlpha()<<"\t"<<bayes_cor<<endl;
	resFile.close();
	
	cout << "hey George" <<endl;
	delete pAlph;
	delete pProbMod;
	delete pDist; 
	delete pPijAcc;
	delete pSp;

	return 0; 
}



/*
int main(int argc, char* argv[]) 
{
	printTime(cerr);
	createOutputDirectories();
	

	
	string treeOutStr = resultsFolder + string("//") + string("init_tree.txt");
	ofstream treeOut(treeOutStr.c_str());
	string mcmctreeOutStr = resultsFolder + string("//") + string("allChainsTree.txt");
	ofstream mcmctreeOut(mcmctreeOutStr.c_str());
	string mltreeOutStr = resultsFolder + string("//") + string("mlTree.txt");
	ofstream mltreeOut(mltreeOutStr.c_str());

	string simSeqFileStr = dirMSA + string("//") + string("simulateMSA.txt");
	ofstream simSeqFile(simSeqFileStr.c_str());
	string simRatesFileStr = dirSimRates + string("//") + string("_simR4s.txt");
	ofstream simRatesFile(simRatesFileStr.c_str());

	string MCMCOutFileStr = resultsFolder + string("//") + string("MCMCRates.txt");
	ofstream MCMCOutFile(MCMCOutFileStr.c_str());
	string MLOutFileStr = resultsFolder + string("//") + string("MLTreeRates.txt");
	ofstream MLOutFile(MLOutFileStr.c_str());
	string BayesTreeOutFileStr = resultsFolder + string("//") + string("BayesTreeRates.txt");
	ofstream BayesTreeOutFile(BayesTreeOutFileStr.c_str());
	string modelTreeOutFileStr = resultsFolder + string("//") + string("modelTreeRates.txt");
	ofstream modelTreeOutFile(modelTreeOutFileStr.c_str());

	string resFileStr = resultsFolder + string("//comparison.txt");
	ofstream resFile(resFileStr.c_str());

	resFile<<"inference" <<"\t" <<"OTU_num"<<"\t" <<"internalL"<<"\t"<<"externalL"<<"\t";
	resFile<<"alpha"<<"\t"<<"correlation"<<endl;



	string treeFile = "Trees\\6_tree.txt";


	MDOUBLE startAlpha = 1.0;
	alphabet* pAlph = new amino;
	replacementModel *pProbMod = new pupAll(datMatrixHolder::jones);
	distribution *pDist = new gammaDistribution(startAlpha, GAMMA_CATEGORIES); 
	pijAccelerator * pPijAcc = new chebyshevAccelerator(pProbMod);
	stochasticProcess* pSp = new stochasticProcess(pDist, pPijAcc);

	////set Run parameters 
	bool bScaleRates = true;
	bool drawRatesRandomly = false;
	int seqLen = 50;
	MDOUBLE ibranchL = 0.1;
	MDOUBLE ebranchL = 0.3;
	int chainsNum = 1;
	int kThinning = 2;
	bool bInferRates = true;
	int alternateSteps = 1000;
	int calibrationCycle = 100;
	int burninSteps = 1000;
	int inferenceSteps = 3000;

	//////////////////////////////////
	
	MDOUBLE model_alpha = 1.0;

	///////////////////////////////////////////////////////////
	tree model_tree(treeFile);
	/////change tree branches
	model_tree.createFlatLengthMatrix(ibranchL);
	vector<tree::nodeP> nodesVec;
	model_tree.getAllNodes(nodesVec, model_tree.iRoot());
	for (int n=0; n<nodesVec.size(); ++n)
	{
		if (nodesVec[n]->father() != NULL)
			if (isLeaf(nodesVec[n]))
				nodesVec[n]->setDisToFather(ebranchL);
			else
				nodesVec[n]->setDisToFather(ibranchL);
	}
	rootToUnrootedTree(model_tree);
	model_tree.output(treeOut);
	//////////////////////////////////////


	/////produce simulation rates and MSA
	string ratesFile = "Rates\\500_SH2_34_forSimulationBayes.txt";
	gammaDistribution gDist(model_alpha, 24);
	SimulateRates sim(model_tree, ratesFile, 2, *pSp, pAlph);
	sim.generateSequencesToMsaFile(seqLen, simSeqFile, simRatesFile, SimulateRates::DISTRIBUTION, &gDist); 
	simSeqFile.close();
	Vdouble simRates = sim.getSimulatedRates();

	ifstream seqFile(simSeqFileStr.c_str());
	sequenceContainer1G seqContainer = maseFormat::read(seqFile,pAlph);
	seqFile.close();

 
	MultiChain multi(chainsNum, pAlph , seqContainer , pSp , resultsFolder, kThinning, model_tree);
	multi.runChains(burninSteps, inferenceSteps, bInferRates, alternateSteps, calibrationCycle);
	multi.printResults(MCMCOutFile);
	tree bayesTree;
	bool bTopology = false;
	multi.getBayesTreeAllChains(bayesTree, bTopology);
	Vdouble mcmcRates;
	multi.getRatesAllChains(mcmcRates);
	bayesTree.output(mcmctreeOut);
	MDOUBLE mcmcAlpha = multi.getAlphaAllChains();

	/////////////////////////////////
	//ML - infer rate4site with posterior 16 categories. 
	//The tree used for inference is the ML tree (branch lengths optimization only)
	tree MLtree(treeFile);
	brLenOptEM::optimizeBranchLength1G_EM(MLtree, seqContainer, *pSp, NULL, 100,0.01);
	MLtree.output(mltreeOut);
	PosteriorR4s mlBayes(MLtree, pAlph, seqContainer, pSp);
	Vdouble mlRates = mlBayes.findRates(bScaleRates, RATE_CATEGORIES, true);
	mlBayes.printRates(MLOutFile);
	MDOUBLE ml_alpha = mlBayes.getAlpha();
	MLOutFile.close();

	/////////////////////////////////
	//BayesTree - infer rate4site with posterior 16 categories. 
	//The tree used for inference is the mcmc tree (average branch lengths over the whole run)
	PosteriorR4s mcBayes(bayesTree, pAlph, seqContainer, pSp);
	Vdouble bayesRates = mcBayes.findRates(bScaleRates, RATE_CATEGORIES, true);
	mcBayes.printRates(BayesTreeOutFile);
	BayesTreeOutFile.close();
	MDOUBLE bayes_alpha = mcBayes.getAlpha();

	/////////////////////////////////
	//modelTree - infer rate4site with posterior 16 categories. 
	//The tree used for inference is the same tree as the one used for the simulation (i.e., the true tree)
	PosteriorR4s modelBayes(model_tree, pAlph, seqContainer, pSp);
	Vdouble modelRates = modelBayes.findRates(bScaleRates, model_alpha, RATE_CATEGORIES, true);
	modelBayes.printRates(modelTreeOutFile);
	modelTreeOutFile.close();

	MDOUBLE model_cor = McRateUtils::calcCorrelationCoefficient(simRates, modelRates);	
	MDOUBLE mcmc_cor = McRateUtils::calcCorrelationCoefficient(simRates, mcmcRates);	
	MDOUBLE ml_cor = McRateUtils::calcCorrelationCoefficient(simRates, mlRates);	
	MDOUBLE bayes_cor = McRateUtils::calcCorrelationCoefficient(simRates, bayesRates);	


	int otu_num = seqContainer.numberOfSequences();
	resFile<<"inference" <<"\t" <<"OTU_num"<<"\t" <<"internalL"<<"\t"<<"externalL"<<"\t"<<"alpha"<<"\t"<<"correlation"<<endl;
	resFile<<"model" <<"\t" << otu_num <<"\t" <<ibranchL<<"\t"<<ebranchL<<"\t"<<model_alpha<<"\t"<<model_cor<<endl;
	resFile<<"mcmc"  <<"\t" << otu_num <<"\t" <<ibranchL<<"\t"<<ebranchL<<"\t"<<mcmcAlpha<<"\t"<<mcmc_cor<<endl;
	resFile<<"ml"  <<"\t" << otu_num <<"\t" <<ibranchL<<"\t"<<ebranchL<<"\t"<<ml_alpha<<"\t"<<ml_cor<<endl;
	resFile<<"bayes"  <<"\t" << otu_num <<"\t" <<ibranchL<<"\t"<<ebranchL<<"\t"<<bayes_alpha<<"\t"<<bayes_cor<<endl;

	resFile.close();
	
	cout << "hey George" <<endl;
	return 0; 
}
*/
