// ProposeLocalBranch.cpp: implementation of the ProposeLocalBranch class.
//
//////////////////////////////////////////////////////////////////////

#include "ProposeLocalBranch.h"
#include "talRandom.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

ProposeLocalBranch::ProposeLocalBranch()
: Proposal()
{
	m_lambda = 0.1;
}

ProposeLocalBranch::~ProposeLocalBranch()
{
	
}

MDOUBLE ProposeLocalBranch::proposeNewState(tree& treeToChange, MDOUBLE& alpha, ParamProposal prop_type)
{
	MDOUBLE newDist, hastingsRatio;
	vector<tree::nodeP> nodesVec;
	treeToChange.getAllNodes(nodesVec, treeToChange.iRoot());
	int i;
	do 
	{
		i = talRandom::giveIntRandomNumberBetweenZeroAndEntry(nodesVec.size());
	}
	while (nodesVec[i]->father() == NULL) ;

	newDist = proposeNewDist(nodesVec[i]->dis2father(), hastingsRatio, prop_type, 0, MAX_BRANCH);
	nodesVec[i]->setDisToFather(newDist);
	return hastingsRatio;
}



void ProposeLocalBranch::updateParameters(MDOUBLE curAcceptanceRate)
{
	if (curAcceptanceRate < m_lowerAcceptance) 
	{
		// Lower lambda in order to increase acceptance rate 
		// Multiply lambda by number from 0.5 to 1
		MDOUBLE multiplier = 1 - talRandom::giveRandomNumberBetweenZeroAndEntry(0.5);
		m_lambda *= multiplier;
	}
	else if (curAcceptanceRate > m_upperAcceptance) 
	{
		// Increase lambda in order to lower acceptance rate
		// Multiply lambda by number from 1 to 2
		MDOUBLE multiplier = 1 + talRandom::giveRandomNumberBetweenZeroAndEntry(1);
		m_lambda *= multiplier;
		if (m_lambda > MAX_LOCAL_LAMBDA)
			m_lambda = MAX_LOCAL_LAMBDA;

	}
}

