#ifndef ___META_RATES
#define ___META_RATES

#include "McRate_Definitions.h"

class Drates;

//class MetaRates represents summary of the rates from the whole chain 
class MetaRates  
{
public:
	MetaRates();
	MetaRates(const MetaRates& other);
	virtual ~MetaRates();

	//addDRate: Adds a single rate to the current MetaRates.
	virtual void addDRate(const Drates * pRates) = 0;

	//addMetaRate: Adds another MetaRates to the current MetaRate.
	virtual void addMetaRate(const MetaRates * pRates, bool bSameWeight) = 0;
	//getWeight: get total number of Drates added 
	virtual int getWeight() const {return m_weight;}

	//getExpectation: gets the expectation of the rate distribution
	virtual MDOUBLE getExpectation() const = 0;
	//getStd: gets the standard deviation of the rate distribution
	virtual MDOUBLE getStd() const = 0;


protected:
	int m_weight; //count the number of DRate added so far to m_distribution
};

#endif  //___META_RATES
