#ifndef ___MCRATE_UTILS
#define ___MCRATE_UTILS

#include "McRate_Definitions.h"
#include <vector>
#include <string>

namespace McRateUtils
{
	////////////////////////////////////
	//vector operations

	//scale vecToScale so that its new average is AvgIn. return the scaling factor. 
	MDOUBLE scaleVec(Vdouble& vecToScale, const MDOUBLE avgIn);
	//calc Pearson correlation coefficient between two vectors
	MDOUBLE calcCorrelationCoefficient(const Vdouble& xVec, const Vdouble& yVec);

	//read from files
	//loadRatesDistributionFromFile: read rates from a rate4site output file and return in ratesVec
	//colNum is the rates column to be read
	void loadRatesDistributionFromFile(string ratesDistFile, Vdouble& ratesVec, int colNum);
};

#endif 
