#if !defined ___MCRATE__OPTION
#define ___MCRATE__OPTION

#ifndef __STDC__
#define __STDC__ 1
#include "getopt.h"
#undef __STDC__
#else
#include "getopt.h"
#endif

#include <string>
#include <fstream>
using namespace std;


#include "McRate_Definitions.h"

class McRateOptions
{
public:					
	enum SeqFileFormat {MASE, CLUSTAL, FASTA, MOLPHY, PHYLIP};
	enum modelNameType {REV, JTT, DAY, AAJC, NUCJC, WAG, CPREV};
	enum treeSearchAlgType {NJ_JC, NJ_ML, ML_MANY_NJ};
	//enum distributionNameType {HOM, GAM};
	
public:
	explicit McRateOptions(int& argc, char *argv[]);
	McRateOptions(const McRateOptions &other);
	virtual ~McRateOptions();

	ostream& out() const {return *m_pOutPtr;};
	int getThinning() const {return m_thinning;}
	int getCategoriesNum() const {return m_numCategories;}
	string getTreeFileStr() const {return m_treefileStr;}
	string getSeqFileStr() const {return m_seqFileStr;}
	

private:
	void readOptions(int& argc, char *argv[]);
	void getModelName();
	void getSeqInputFormat();
	void getChainParam();
	void printHelp(char *argv[]); 

//private:
public:
	friend class McRate;
	friend class MultiChain;
	string m_treefileStr;
	string m_seqFileStr;
	string m_logFileStr;
	string m_outDirStr;
	string m_referenceSeq; // the results are printed with a this reference seq in each position.
	int m_logValue;

	SeqFileFormat m_seqInputFormat;
	modelNameType m_modelName;
	
	int m_alphabet_size;
	bool m_bRemoveGaps;
	//chain Parameters
	int m_chainsNum;
	int m_numCategories; //the number of discrete rate categories to be used. 
	int m_calibrationCycle;
	int m_thinning;
	int m_alternateSteps;

	int m_burningTime;
	int m_inferenceTime;

	bool m_bStopChainsIfRateConverged;
	bool m_bDoCorrelationTest;
	int m_minSteps;
	MDOUBLE m_rLimit;
	MDOUBLE m_epsilonLimit;
	int m_stepsInLimit;

	bool m_bScale;
	bool m_bInferRates;

    ostream* m_pOutPtr;
    ofstream m_outFile;

};


#endif
