#ifndef ___MRATE_DISC
#define ___MRATE_DISC

#include "MetaRates.h"
#include "McRate_Definitions.h"
#include "RateProb.h"

#include <fstream>

//MRateDisc represents a discrete distribution of rates. 
//This distribution is the summary of all the chain' steps.
//the distribution is represented by a vector of RateProb:
class MRateDiscrete : public MetaRates
{
public:
	MRateDiscrete();
	MRateDiscrete(const MRateDiscrete& other);
	virtual ~MRateDiscrete();

	//addDRate: Adds a single rate (distribution) to the current MRate.
	virtual void addDRate(const Drates * rates);

	//addMetaRate: Adds a rate distribution (MRateDiscrete) to the current MRateDiscrete.
	virtual void addMetaRate(const MetaRates * pRates, bool bSameWeight);
	
	//getExpectation: gets the expectation of the distribution
	virtual MDOUBLE getExpectation() const;
	//getStd: gets the standard deviation of the distribution
	virtual MDOUBLE getStd() const;

	void printDistribution(ofstream &outFile);

	int MRateDiscrete::size() const;

private:
	MDOUBLE calcExpectation() const;


private:
	vector<RateProb> m_distribution;
	MDOUBLE m_expectation; //holds the current expectation of the distribution 

};

#endif  //___MRATE_DISC
