#ifndef ___MRATE_CONT
#define ___MRATE_CONT

#include "MetaRates.h"
#include "Bar.h"
#include "McRate_Definitions.h"

#include <fstream>

class Drate;

//MRateCont represents a continous distribution of rates. 
//This distribution is the summary of all the chain' steps.
//The distribution is represented by equal size bars (intervals). 
//The size of each bar is (m_upper_limit - m_lower_limit)/ m_barNum
class MRateCont : public MetaRates
{
public:
	//Init MRateCont with the number of Bars to be used. Sets the upper and lower limits of the distribution 
	MRateCont(const int bar_num, const MDOUBLE lower_limit = 0 , const MDOUBLE upper_limit = MAX_RATE_LIMIT);
	MRateCont(const MRateCont& other);
	virtual ~MRateCont();

	//addDRate: Adds a single rate (distribution) to the current MRateCont.
	virtual void addDRate(const Drates * rates);

	//addMetaRate: Adds a rate distribution (MRateCont) to the current MRateCont.
	virtual void addMetaRate(const MetaRates * pRates, bool bSameWeight);
	//getWeight: get total number of Drates added 
	
	//getExpectation: gets the expectation of the distribution
	virtual MDOUBLE getExpectation() const;
	//getStd: gets the standard deviation of the distribution
	virtual MDOUBLE getStd() const;

	void printDistribution(ofstream &outFile);

private:

	void init();

	//updateBar: adds a value to the ith Bar. the new value is the average of all values until now
	void updateBar(const int barNum, const MDOUBLE val_to_add);

private:
	int m_barNum;
	const MDOUBLE m_lower_limit;
	const  MDOUBLE m_upper_limit;
	MDOUBLE m_interval;// m_upper_limit - m_lower_limit
	VBar m_distribution; //the actual distribution. represented as a vector of Bars.
};

#endif  //___MRATE_CONT
