#ifndef ___DRATE_DISC
#define ___DRATE_DISC


#ifndef unix
#pragma warning (disable:4786)
#endif

#include "Drates.h"
#include "McRate_Definitions.h"
#include "RateProb.h"
#include "gammaDistribution.h"

//DrateDiscretet represents a discrete distribution of rates.
//the distribution is represented by 2 vectors:
//1. m_rateVec hold the rates values (i.e., the rates that were chosen to represent the gamma distribution)
//2. m_probVec holds the probabilities of the rates. m_probVec[i] is the probability of m_rateVec[i]
class DrateDiscrete : public Drates
{
public:
	DrateDiscrete();
	DrateDiscrete(const DrateDiscrete& other);
	virtual ~DrateDiscrete();

	//getExpectation: gets the expectation of the distribution
	virtual MDOUBLE getExpectation() const;

	//scale: multiply the whole distribution by scaleFacotr so that the average will be one
	virtual void scale(MDOUBLE scaleFactor);

	//sets m_probVec according to probVec and m_rateVec according to the cvategories of pDist
	virtual void setProb(const Vdouble & probVec, const gammaDistribution* pDist);
	
	//return the number of discrete categories
	int size() const;

	MDOUBLE getProb(const int ri) const {return m_distribution[ri].getProb();}
	MDOUBLE getRate(const int ri) const {return m_distribution[ri].getRate();}
	RateProb getRateP(const int i) const {return m_distribution[i];} 
	RateProb& operator[](const int i) {return m_distribution[i];}
	

private:
	vector <RateProb> m_distribution;
};

#endif  //___DRATE_DISC
