#include "DrateDiscrete.h"
#include "errorMsg.h"
#include "McRateUtils.h"
#include "someUtil.h"

#include <cmath>
#include <cassert>
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


DrateDiscrete::DrateDiscrete()
: m_distribution(0)
{
}


DrateDiscrete::DrateDiscrete(const DrateDiscrete& other)
{
	int catNum = other.size();
	
	m_distribution.resize(catNum);
	int i;
	for (i = 0; i < catNum; ++i)
	{
		m_distribution[i] = other.m_distribution[i];
	}
}


//return the number of discrete categories
int DrateDiscrete::size() const
{
	return m_distribution.size();
}


DrateDiscrete::~DrateDiscrete()
{

}


//scale: multiply the whole distribution by scaleFacotr
void DrateDiscrete::scale(MDOUBLE scaleFactor)
{
	int i;
	for (i = 0; i < m_distribution.size(); ++i)
	{
		m_distribution[i].setRate(scaleFactor * m_distribution[i].getRate());
	}
}




//getExpectation: gets the expectation of the distribution
MDOUBLE DrateDiscrete::getExpectation() const
{
	MDOUBLE res = 0.0;
	MDOUBLE r, Pr, sigmaPr = 0.0;
	int i;
	for (i = 0; i < m_distribution.size(); ++i)
	{
		r = m_distribution[i].getRate();
		Pr = m_distribution[i].getProb();
		res += r * Pr;
		sigmaPr += Pr;
	}

	if (!DEQUAL(sigmaPr, 1.0))
		errorMsg::reportError("total probability != 1.0 in function DrateDiscrete::getExpectation()");

	return res;
}


void DrateDiscrete::setProb(const Vdouble& probVec, const gammaDistribution* pDist)
{
	if (probVec.size() != pDist->categories())
		errorMsg::reportError("probVec is not same size as the number of discrete categories in DrateDiscrete::setProb()");
	
	m_distribution.resize(probVec.size());
	
	int ri;
	for (ri = 0; ri < m_distribution.size(); ++ri)
	{
		m_distribution[ri].setRateP(pDist->rates(ri), probVec[ri]);
	}
}
