#ifndef ___DRATE_CONT
#define ___DRATE_CONT


#ifndef unix
#pragma warning (disable:4786)
#endif

#include "Drates.h"
#include "McRate_Definitions.h"
#include "Bar.h"

#include "gammaDistribution.h"

//DrateCont represents a continous distribution of rates.
//the distribution is represented by UN-EQUAL size bars (intervals).
//The size of each BAR is determind so that each contain 1/k of the prior distribution (where k=bars_num).
//The prior gamma distribution is based on its alpha parameter.  
class DrateCont : public Drates
{
public:
	DrateCont(const int bar_num, const MDOUBLE lower_limit , const MDOUBLE upper_limit);
	DrateCont(const DrateCont& other);
	DrateCont(const VBar& distribution);
	virtual ~DrateCont();

	
	VBar getBars() const;
	MDOUBLE getMinBound() const {return m_minimum_limit;} 
	MDOUBLE getMaxBound() const {return m_maximum_limit;} 

	//getExpectation: gets the expectation of the distribution
	virtual MDOUBLE getExpectation() const;

	//scale: multiply the whole distribution by scaleFacotr
	virtual void scale(MDOUBLE scaleFactor);

	virtual void setProb(const Vdouble & pVec, const gammaDistribution* pDist);

	Bar& operator[](const int i) {return m_distribution[i];}


private:
	//reset the bar distribution so that it will match pInDist 
	void resetDistribution(const gammaDistribution* pDist);

private:
	MDOUBLE m_minimum_limit; //the minimum lower limit allowed
	MDOUBLE m_maximum_limit; //the maximum upper limit allowed
	VBar m_distribution;
};

#endif  //___DRATE_CONT
