#ifndef ___COUNTER
#define ___COUNTER
#ifndef unix
#pragma warning (disable:4786)
#endif

#include "McRate_Definitions.h"

//Class Counters holds info about the number of steps made.
//Holds the total number of steps made by the chain 
//and the number of steps since the chain was last calibrated (during Burn-in time).
class Counters  
{
public:
	Counters();
	virtual ~Counters();
	
	//zeroCounters: set to zero  m_lastSteps and  m_lastAccepted. Must be called after the chain has been calibrated
	void zeroCounters ();
	//resetCounters: set to zero all counters.
	void resetCounters();
	int getLastStepNum () const {return m_lastSteps;}  
	int getTotalStepNum () const {return m_totalSteps;}  
	MDOUBLE getTotalAccRate() const;
	//getLastAccRate: Gets the acceptance rate since the chain has been calibrated
	MDOUBLE getLastAccRate() const;
	//update: increment the number of steps. If bIsAccepted == true then the step has been accepted.
	void update (const bool bIsAccepted);

public:
	int m_totalSteps; //total number of steps
	int m_totalAccepted;
	int m_lastSteps; //number of steps from last ZeroCounters()
	int m_lastAccepted; //number of steps from last ZeroCounters()
};

#endif // ___COUNTER
