#include "Counters.h"

Counters::Counters()
{
	m_totalSteps = 0;
	m_totalAccepted = 0;
	m_lastSteps = 0;
	m_lastAccepted = 0;
}

Counters::~Counters()
{

}

void Counters::zeroCounters()
{
	m_lastSteps = 0;
	m_lastAccepted = 0;
}

void Counters::resetCounters()
{
	m_totalSteps = 0;
	m_totalAccepted = 0;
	m_lastSteps = 0;
	m_lastAccepted = 0;
}

MDOUBLE Counters::getTotalAccRate() const
{
	return (static_cast<MDOUBLE>(m_totalAccepted)/static_cast<MDOUBLE>(m_totalSteps));
}

MDOUBLE Counters::getLastAccRate() const
{
	return (static_cast<MDOUBLE>(m_lastAccepted)/static_cast<MDOUBLE>(m_lastSteps));
}

void Counters::update(const bool bIsAccepted)
{
	if (bIsAccepted) 
	{
		++m_totalAccepted;
		++m_lastAccepted;
	}
	++m_totalSteps;
	++m_lastSteps;
}
