// Bar.h: interface for the Bar class.
//
//////////////////////////////////////////////////////////////////////
#ifndef ___BAR
#define ___BAR

#ifndef unix
#pragma warning (disable:4786)
#endif

#include "McRate_Definitions.h"

//class Bar represents one bar of distribution.
//m_lower_limt and m_upper_limit are the Bar's boundaries and m_density is the height.
//the probability of the bar is the area it occupied =  (m_upper_limit - m_lower_limit) * value
class Bar  
{
public:
	Bar();
	Bar(const MDOUBLE val, const MDOUBLE lower_limit, const MDOUBLE upper_limit);
	virtual ~Bar();

	void setDensity(const MDOUBLE new_val);
	MDOUBLE getDensity() const {return m_density;}
	void setBounderies(const MDOUBLE lower_limit, const MDOUBLE upper_limit, bool bConstProb);
	MDOUBLE getLowerLimit() const {return m_lower_limit;} 
	MDOUBLE getUpperLimit() const {return m_upper_limit;}
	MDOUBLE getMidPoint() const;
	//getProb: Gets the probability of the bar (i.e., the area it occupies).
	MDOUBLE getProb() const;
	void setProb(const MDOUBLE p);

private:

	MDOUBLE m_density;
	MDOUBLE m_prob;
	MDOUBLE m_lower_limit;
	MDOUBLE m_upper_limit;
};

typedef vector<Bar> VBar;

#endif //__BAR
