// Bar.cpp: implementation of the Bar class.
//
//////////////////////////////////////////////////////////////////////

#include "Bar.h"
#include "errorMsg.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
Bar::Bar()
{
	m_prob = 0.0;
	m_density = 0;
	m_lower_limit = 0;
	m_upper_limit = 0;
}


Bar::Bar(const MDOUBLE density, const MDOUBLE lower_limit, const MDOUBLE upper_limit)
{
	if (m_lower_limit >= m_upper_limit)
		errorMsg::reportError("lower limit is larger than upper limit in function Bar::Bar");
	
	m_lower_limit = lower_limit;
	m_upper_limit = upper_limit;
	setDensity(density);

}

Bar::~Bar()
{

}


void Bar::setDensity(const MDOUBLE new_val)
{
	if (new_val < 0.0)
		errorMsg::reportError("density is smaller than zero in Bar::setDensity()");

	m_density = new_val;
	m_prob = m_density * (m_upper_limit - m_lower_limit);
	if ((m_prob > 1.0) || (m_prob < 0.0))
		errorMsg::reportError("probability is not between one an dzero in Bar::setDensity()");
}

void Bar::setProb(const MDOUBLE p)
{
	if ((p > 1.0) || (p < 0.0))
		errorMsg::reportError("probability is not between one an dzero in Bar::setProb()");

	m_prob = p; 
	m_density = p / (m_upper_limit - m_lower_limit);
	if (m_density < 0.0)
		errorMsg::reportError("density is smaller than zero in Bar::setProb()");

}


//set new bounderies. if bConstProb==TRUE then set new density such that the probability is constant. 
//if bConstProb==FALSE then density is const and change the probability 
void Bar::setBounderies(const MDOUBLE lower_limit, const MDOUBLE upper_limit, bool bConstProb)
{
	if (lower_limit >= upper_limit)
	{
		errorMsg::reportError("lower limit is larger than upper limit in function BBar::SetBounderies");
	}
	m_lower_limit = lower_limit;
	m_upper_limit = upper_limit;

	if(bConstProb == true)
	{
		setProb(m_prob);
	}
	else
	{
		setDensity(m_density);
	}
}


MDOUBLE Bar::getMidPoint() const 
{
	return (m_lower_limit + m_upper_limit) / 2;
}


MDOUBLE Bar::getProb() const
{
	return m_prob;
}

