/* Copyright (C) 2007 the NxOS developers
 *
 * See AUTHORS for a full list of the developers.
 *
 * Redistribution of this file is permitted under
 * the terms of the GNU Public License (GPL) version 2.
 * 
 * modified by Sivan Toledo
 */

void memcpy(void *dest, const void *source, uint32_t len) {
  uint8_t *dst = (uint8_t*)dest;
  uint8_t *src = (uint8_t*)source;
  while (len--) {
    *dst++ = *src++;
  }
}

void memset(void *dest, const uint8_t val, uint32_t len) {
  uint8_t *dst = (uint8_t*)dest;
  while (len--) {
    *dst++ = val;
  }
}

uint32_t strlen(const char *str) {
  uint32_t i = 0;

  ASSERT(str != NULL);

  while (*str++)
    i++;

  return i;
}

uint32_t strncmp(const char *a, const char *b, uint32_t n) {
  uint32_t i;

  ASSERT(a != NULL && b != NULL);

  for (i=0 ; i<n ; i++) {
    if (a[i] < b[i]) {
      return -1;
    } else if (a[i] > b[i]) {
      return 1;
    }
  }

  return 0;
}

uint32_t strcmp(const char *a, const char *b) {
  return strncmp(a, b, strlen(a) < strlen(b)+1 ? strlen(a) : strlen(b)+1 ); // +1 was in the NxOS sources; don't know why; sivan
}

char *strchr(const char *s, const char c) {
  ASSERT(s != NULL);

  while (*s) {
    if (*s == c)
      return (char*)s;
    s++;
  }

  return NULL;
}

char *strrchr(const char *s, const char c) {
  const char *ptr = NULL;

  ASSERT(s != NULL);

  while (*s) {
    if (*s == c)
      ptr = s;
    s++;
  }

  return (char*)ptr;
}
