SECTIONS
{
  . = 0x001ffff0; /* addressed in the binary start from  */
                  /* here, 16 bytes before RAM starts    */
                   
  .text : { startup_from_std_firmware.o (.text) } 
  .text : { 
    *(.text)                   /* remaining code             */
    *(.glue_7t) *(.glue_7)     /* for arm-thumb interworking */
  } 

  . = ALIGN(4);

  /* .rodata section which is used for read-only data (constants) */

  .rodata : { *(.rodata) }

  . = ALIGN(4);

  /* .data section which is used for initialized data */

  .data : 
  {
    *(.data)
    SORT(CONSTRUCTORS)
  }
  . = ALIGN(4);

  /* .bss section which is used for uninitialized data */

  .bss :
  {
    __bss_start__ = . ;
    *(.bss)
    /* *(COMMON) */
  } 

  . = ALIGN(4);
  __bss_end__ = . ;
  
}
