/*
   Sivan Toledo, May 2008
   to enable calling a native AT91SAM7 program 
   from the NXT's firmware, using a modification
   implemented by John Hansen.
   
   The NXT firmware recognizes a native file by the
   string "NXTBINARY" at the beginning of the file.
   To keep the changes in the NXT's firmware minimal,
   the file name must be .rxe (same as the stadard
   NXT binaries which are for a virtual machine).
   
   When the NXT's firmware recognizes a native file,
   it calls a function at offset X in the file, where
   X is the 32-bit number stored in offset 12 in the file.
   The firmware passes two arguments to the function: the 
   address of the file in flash, and the length of the file. 

    The code in this file uses the arguments (location and size
    of the native file) to relocate the file (except for the first 16
    bytes, which are a header) to the beginning of RAM, initialize
    the AT91SAM7S, and initialize the C environment (stack and variables
    that initialized to zero).
*/

/* 
   The NXT header must be 16 bytes, since the linker
   script locates it 16 bytes below the beginning of RAM,
   so the vectors will be at the beginning of RAM, which
   we memory map to address 0.
*/

    /* .text is used instead of .section .text so it works with arm-aout too.  */
    .text
	.code 32 /* Assemble in ARM mode, not Thumb mode */
		
NXT_Binary_Header:
    /*
     * Marker for standard firmware.
     */
	.ascii "NXTBINARY\0\0\0"
    /*
     * The firmware expects to see at offset 12 in the
     * file the offset of the entry function from the
     * firmware. We compute it dynamically here, but
     * in this code it evaluates to 48 (16-byte header
     * plus 32 bytes of vectors).
     */
	.word  NXT_Entry_Point - NXT_Binary_Header
	
/*------------------------------------------------------------------------------
*- Area Definition
*------------------------------------------------------------------------------*/
        .global _startup
        .func   _startup
_startup:
/*------------------------------------------------------------------------------
//*- Exception vectors 
//*--------------------
//*- These vectors can be read at address 0 or at RAM address
//*- They ABSOLUTELY requires to be in relative addresssing mode in order to
//*- guarantee a valid jump. For the moment, all are just looping.
//*- If an exception occurs before remap, this would result in an infinite loop.
//*- To ensure if a exeption occurs before start application to infinite loop.
//*------------------------------------------------------------------------------*/
Vectors:        LDR     PC, Reset_Addr         
                B  . // undef is not handled
                B  . // swi is not handled
                B  . // pabt is not handled
                B  . // dabt is not handled
                NOP                            /* Reserved Vector */
                LDR     PC, [PC, #-0x0F20] /* IRQ, vectored by AIC */
                LDR     PC, [PC, #-0x0F20] /* FIQ, vectored by AIC */
                
/* 
 * Entry into native code from NXT firmware; 
 * this function must be located at offset 48 in the file 
*/
NXT_Entry_Point:

	/* globally disable interrupts */
	STMDB	SP!, {R0}		/* Push R0.						*/	
	MRS	R0, CPSR			/* Get CPSR.					*/	
	ORR	R0, R0, #0xC0		/* Disable IRQ, FIQ.			*/	
	MSR	CPSR, R0			/* Write back modified value.	*/	
	LDMIA	SP!, {R0}		/* Pop R0.						*/

Copier:
 	add	r2, r0, r1      // r2 now holds the address just beyong
 	                    // the end of this binary file
 	mov	r1, #2097152	// 0x200000, beginning of RAM
 	add	r0, r0, #16	    // skip the header!

 	b	CopierCompare
CopierLoop:
  	ldr	r3, [r0], #4
   	str	r3, [r1], #4
CopierCompare:
  	cmp	r0, r2
   	bcc	CopierLoop
   		
JumpToResetVector:
 	mov	PC, #2097152

Reset_Addr:     .word   InitReset

InitReset:
# Setup Stack for relevant modes; modes without a stack cannot use a stack
# (but here they are infinite loops anyway).
        .equ    FIQ_Stack_Size, 0x00000080
        .equ    IRQ_Stack_Size, 0x00000400
        .equ    SYS_Stack_Size, 0x00000400 // last stack, so has no effect
# Standard definitions of Mode bits and Interrupt (I & F) flags in PSRs							
        .equ    Mode_USR,       0x10
        .equ    Mode_FIQ,       0x11
        .equ    Mode_IRQ,       0x12
        .equ    Mode_SVC,       0x13
        .equ    Mode_ABT,       0x17
        .equ    Mode_UND,       0x1B
        .equ    Mode_SYS,       0x1F

        .equ    I_Bit,          0x80    /* when I bit is set, IRQ is disabled */
        .equ    F_Bit,          0x40    /* when F bit is set, FIQ is disabled */


		.equ	Top_Stack,		0x0210000

         LDR     R0, =Top_Stack

#  Enter FIQ Mode and set its Stack Pointer
          MSR     CPSR_c, #Mode_FIQ|I_Bit|F_Bit
          MOV     SP, R0
          SUB     R0, R0, #FIQ_Stack_Size

#  Enter IRQ Mode and set its Stack Pointer
           MSR     CPSR_c, #Mode_IRQ|I_Bit|F_Bit
           MOV     SP, R0
           SUB     R0, R0, #IRQ_Stack_Size

#  Enter System Mode and set its Stack Pointer, and stay there
           MSR     CPSR_c, #Mode_SYS|I_Bit|F_Bit
           MOV     SP, R0

# Clear .bss section (uninitialized variables)
                MOV     R0, #0
                LDR     R1, =__bss_start__
                LDR     R2, =__bss_end__
LoopZI:         CMP     R1, R2
                STRLO   R0, [R1], #4
                BLO     LoopZI


//	//*AT91C_RSTC_RCR = AT91C_RSTC_KEY | AT91C_RSTC_PERRST;
ResetPeripherals:
 	ldr	r2, ResetPeripheralsValue
	mvn	r3, #0
 	str	r2, [r3, #-767]

  // these nops appear to be necessary before the remapping command,
  // which otherwise does not take effect. Three is the minimum.

  nop
  nop
  nop

	// remap command; RAM becomes mapped to first MB of address space,
	// which maps our interrupt vectors starting from address zero.

	.equ    MC_BASE,0xFFFFFF00  /* MC Base Address */
	.equ    MC_RCR, 0x00        /* MC_RCR Offset */

	LDR     R0, =MC_BASE
	MOV     R1, #1
	STR     R1, [R0, #MC_RCR]

JumpToC:		
	ldr	lr,=exit
	ldr	r0,=c_startup
	bx	r0

ResetPeripheralsValue: 
  .word   0xA5000004

  .size   _startup, . - _startup
  .endfunc
		
  .global exit
  .func   exit
exit:
	b    .
	.size   exit, . - exit
  .endfunc

  .end

	
