// Sivan Toledo, 2008
// demo file to demonstrate invocation of native C code
// from the NXT's firmware.

#include "at91sam7s256.h" /* vendor's definition of SFRs     */
#include "stdint.h"       /* GCC definitions of int32_t etc. */

#ifndef NULL
#define NULL ((void*)0)
#endif

#define ASSERT(x)

typedef uint32_t bool;
#define FALSE (0) 
#define TRUE (!FALSE)
#define MIN(x,y) ((x) < (y) ? (x) : (y))
  
#define NXT_N_MOTORS   3
#define NXT_N_SENSORS  4

static void avrPeriodicTask(void);
static void lcdPeriodicTask(void);
#define systick_periodic_task() { avrPeriodicTask(); lcdPeriodicTask(); }

#include "version.h"
#include "util.h"
#include "clocks.h"
#include "aic.h"
#include "systick.h"
#include "dsr.h"
#include "sensorports.h"

//#include "i2c.h"
#include "avr.h"

static void simplemotorcontrolTachoChangeHandler(void);
#define tacho_change_event() simplemotorcontrolTachoChangeHandler()
#include "tacho.h"
#include "simplemotorcontrol.h"

#include "display.h"
#include "sound.h"


#define bt_inquiry_result_event( r ) { displayString(r); displayString("\n"); }

//#include "bt.h"
#include "nxtfs.h"

/*
 * A couple of deferred service routines, to how to define
 * and post them.
 */

void ledOnDsr(void) {
  sensorportsDigiSet(0,0);
}
dsr_t ledOnDsrObj = { ledOnDsr };

void ledOffDsr(void) {
  sensorportsDigiClear(0,0);
}
dsr_t ledOffDsrObj = { ledOffDsr };


/*
 * This function is called by the assembly startup code.
 * The C environment (stack and variable initialization) is
 * done, and RAM is mapped to the reset vectors. But interrupts
 * are still disabled, and since all peripherals have
 * been initialized, we are running off the slow clock 
 * (approximately 32 kHz), which is really slow!
 * 
 * c_startup should not return.
 */

void c_startup() {
	
  clocksInit();     /* start up the fast system clock.   */
  aicInit();        /* set up the interrupt controller.  */
  systickInit();    /* periodic tasks & busywait.        */
  avrInit();        /* the AVR will turn off the NXT if  */
                    /* we don't talk to it periodically. */

  lcdInit();
  dsrInit();        /* optional.                         */
  //i2cInit();
  sensorportsInit();
  tachoInit();
  soundInit();
  //usbInit();

  interruptsEnable();
    
  nxtfsDemo();
  
  /* To try this code, connect 
   * the light sensor to port 1, 
   * the touch sensor to port 2,
   * and 3 motors; the one connected to port C
   * must be a NXT servo.
   */ 
  
  while (1) {
    switch (buttonGet()) {
      case BUTTON_LEFT:   motorSet(MOTOR_A,  100, FALSE); break;
      case BUTTON_RIGHT:  motorSet(MOTOR_A, -100, FALSE); break;
      //case BUTTON_CANCEL: { soundFreqDuration(700,200); motorsRotateTime(MOTOR_C, 100, 500, TRUE); }  break;
      case BUTTON_CANCEL: { simplemotorcontrolRotateAngle(MOTOR_C, 180);   }  break;
      // case BUTTON_CANCEL: { lcdShutdown(); powerOff();   }  break;
      case BUTTON_OK:     { lcdShutdown(); powerReset(); } break;
      default:            motorSet(MOTOR_A,    0, TRUE ); break;
    }
    
    displayCursorSetPosition(0,1);
    displayString("        ");
    displayCursorSetPosition(0,1);
    displayUInt( sensorportsGetRaw(0) );

    displayCursorSetPosition(0,3);
    displayString("batt:         ");
    displayCursorSetPosition(6,3);
    displayInt( powerGetBatteryVoltage() );

    displayCursorSetPosition(0,4);
    displayString("        ");
    displayCursorSetPosition(0,4);
    displayInt( tachoGetCount(2) );

    displayCursorSetPosition(0,5);
    displayString("        ");
    displayCursorSetPosition(0,5);
    displayInt( _simplemotorcontrol_state[2].target );

    busywait(200*1000);
    if (sensorportsGetRaw(1) < 512) { dsrPost( &ledOnDsrObj  ); motorSet(MOTOR_B,  100, FALSE); }
    else                            { dsrPost( &ledOffDsrObj ); motorSet(MOTOR_B,    0, FALSE); }
    //if (analogsensorRaw(1) < 512) { sensorportsDigiSet(0,0);   motorSet(MOTOR_B,  100, FALSE); }
    //else                          { sensorportsDigiClear(0,0); motorSet(MOTOR_B,    0, FALSE); }
  }
}


