/*
 * Sivan Toledo, May 2008.
 *
 * Code is distributed under GPL 2.
 */
 
 #define MCK_FREQ (18432000*73/14/2)
 
/*
 * This sets up the normal 48 MHz clock of the NXT.
 * You can use pretty much any other frequency up to
 * 55 MHz if you do not use use USB.
 */
static void clocksInit(void) {
  /* Set flash mode register */
  *AT91C_MC_FMR = AT91C_MC_FWS_0FWS   /* 1/2 (R/W) wait states                  */
                | (50 << 16);         /* number of master clock cycles per usec */ 

  /* Main oscillator */
  *AT91C_CKGR_MOR = AT91C_CKGR_MOSCEN /* enable */
                  | (6 << 8);         /* OSCOUNT wait period (6*8 slow clocks)  */
  while ((*AT91C_PMC_SR & 1) == 0);   /* wait for MOSCS, main oscillatgor stable*/ 

  /* Set the PLL to get a 48MHz clock from the 18.432MHz crystal */
  /* We divide by 14, multiply by 73, then divide by 2; this     */
  /* gives 48.055MHz, which is accurate enough for USB.          */
  
  *AT91C_CKGR_PLLR = 0x10481C0E;
  while ((*AT91C_PMC_SR & 4) == 0);   /* wait for PLL Lock                      */ 
  while ((*AT91C_PMC_SR & 8) == 0);   /* wait for stable master clock           */ 

  /* setting the source and prescaler of the master clock        */
  /* must be done in 2 steps                                     */
  *AT91C_PMC_MCKR = 4;                /* stay on slow clock, divide by 2        */
  while ((*AT91C_PMC_SR & 8) == 0);   /* wait for stable master clock           */ 
  *AT91C_PMC_MCKR = 7;                /* select PLL clock, divide by 2          */
  while ((*AT91C_PMC_SR & 8) == 0);   /* wait for stable master clock           */ 
}
