function mesh2d_plot(w,h,U,decorations)

  clf;
	
	if (nargin < 4)
		decorations.dummy = 1;
	end
	if (~isfield(decorations,'show_labels'))
		decorations.show_labels = false;
	end
	if (~isfield(decorations,'permutation'))
		decorations.permutation = 1:h*w;
	end
	
	%if ~ strcmp(class(show_labels),'logical')

	p           = decorations.permutation;
	show_labels = decorations.show_labels;
	
	marker_size = 0.4;
	
	axis( [ 1-0.65*marker_size
		      w+0.65*marker_size
		      1-0.65*marker_size
					h+0.65*marker_size ] );
	axis equal
	axis off;
	
	if (isfield(decorations,'under'))
	  % for a nested dissection example, at bottom
  	g = rectangle('Position',decorations.under,... %[ 0.5 3.5 3 1],...
	              'Curvature',[1 1],...
							  'EdgeColor','none',...
							  'FaceColor',[.66 .66 .66]...
							  );
	end
	
	% decide on edge width
	
	%set(gca,'Units','normalized');
	%position = get(gca,'Position');
	%normalized_width = position(3);
	
	normalized_height = (h-1)+2*0.65*marker_size;
	set(gca,'Units','points');
	position = get(gca,'Position');
	point_height = position(4);
	points_per_unit = point_height / normalized_height
	line_width = 0.15 * marker_size * points_per_unit
	%line_width = 1.5
	
	
	% draw the edges
	
	for e=1:size(U,2)
	  vertices = find(U(:,e));
		if length(vertices) > 2
			error('U is not an incidence factor');
		end
		if length(vertices) == 2
			[x1,y1] = coordinates( vertices(1) );
			[x2,y2] = coordinates( vertices(2) );
			g = line( [x1 x2], [y1 y2] );
  		set(g,...
				  'LineWidth',line_width,...
					'Color',[0 0 0]);
		end
	end
	
	% we compute the pointsize for text
	
	if show_labels
		g = text(2,2,sprintf('%d',w*h));
		set(g ...
		  	,'HorizontalAlignment','center' ...
			  ,'FontWeight','Bold' ...
			  ,'FontSize',10 ...
			  );
		extent = get(g,'Extent');
	  ratio = 0.85*marker_size / extent(3); % extent(3) is the width
	  font_size = 10 * ratio;
	  delete(g);
	end
	
	% now draw the vertices
	
	for i=1:w*h
		[x,y] = coordinates(p(i));
		% [i x y]
		marker = [ x-marker_size/2 
			         y-marker_size/2 
							 marker_size
							 marker_size ]';
		g = rectangle('Position',marker,'Curvature',[1 1]);
		set(g,...
			  'LineStyle','none',...
			  'FaceColor',[.5 .5 .5]);
		if show_labels
  		g = text(x,y,sprintf('%d',i));
 	    set(g ...
		    	,'HorizontalAlignment','center' ...
			    ,'FontWeight','Bold' ...
			    ,'FontSize',font_size ...
			    );
		end

	end
	
	%if (nargin >= 5)
  %	print('-depsc2',file_name);
	%end
	
	function [x,y] = coordinates(i)
		y = 1 + floor( (i-1) / w );
		x = 1 + rem( (i-1), w );
	end

end