function U = mesh2d(w,h)
%MESH2D     Computes the canonical incidence factor of an h-by-w mesh

  n = h*w;
	m = 2*n - h - w;
	[n m];
	
	r = zeros(1,2*m);
	c = zeros(1,2*m);
	v = zeros(1,2*m);
	
	next_edge    = 1;
	next_nonzero = 1;
	for y=1:h
		for x=1:w
			i = w*(y-1) + x; % index of this vertex
			if x<w
				j = i+1; % next vertex to the right
				
				r(next_nonzero) = i;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = +1;
				next_nonzero = next_nonzero + 1;
				
				r(next_nonzero) = j;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = -1;
				next_nonzero = next_nonzero + 1;

				next_edge = next_edge + 1;

			end
			if y<h
				j = i+w; % next vertex down
				
				r(next_nonzero) = i;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = +1;
				next_nonzero = next_nonzero + 1;
				
				r(next_nonzero) = j;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = -1;
				next_nonzero = next_nonzero + 1;

				next_edge = next_edge + 1;

			end
		end
	end
	
	U = sparse(r,c,v,n,m,2*m);
end