function Ke = linear_element_2d(x,y,material_constant)
%
% function Ke = linear_element_2d(x,y,material_constant)
%  
% Generates a 3x3 matrix for a linear triangular element
%  with given coordinates 'x' and 'y' and a constant
%  'material_constant'.
%
% S. Toledo, H. Avron, G. Shklarski. March 2007
% All rights reserved.


if (nargin < 2)
    material_constant = 1;
end

Ke = zeros(3,3);

A = 0.5*det([1 x(1) y(1);
	     1 x(2) y(2);
	     1 x(3) y(3)]);

if (A < 0),
  error('Bad point orientation');
end

if (abs(A) < 1e-14),
  [N1,N2,N3,x(1),y(1),x(2),y(2),x(3),y(3)]
  error('3 points almost on a line');
end

Ke(1,1) = (x(3)-x(2))^2 + (y(2)-y(3))^2;
Ke(1,2) = (x(3)-x(2))*(x(1)-x(3)) + (y(2)-y(3))*(y(3)-y(1));
Ke(1,3) = (x(3)-x(2))*(x(2)-x(1)) + (y(2)-y(3))*(y(1)-y(2));
Ke(2,1) = Ke(1,2);
Ke(2,2) = (x(1)-x(3))^2 + (y(3)-y(1))^2;
Ke(2,3) = (x(1)-x(3))*(x(2)-x(1)) + (y(3)-y(1))*(y(1)-y(2));
Ke(3,1) = Ke(1,3);
Ke(3,2) = Ke(2,3);
Ke(3,3) = (x(2)-x(1))^2 + (y(1)-y(2))^2;

Ke = material_constant*Ke/(4*A);
