function [U,p] = joshi2d(w,h,k)
% returns a Joshi-style preconditioner for a 2D mesh,
% and an elimination ordering for it.
% k is the size of top-level squares

  n = h*w;
	m = 2*n; % just an upper limit
	[n m];
	
	r = zeros(1,2*m);
	c = zeros(1,2*m);
	v = zeros(1,2*m);
	
	next_edge    = 1;
	next_nonzero = 1;
	
	% first, the contiguous horizontal ribs
	
	for y=1:k:h
		for x=1:w
			i = w*(y-1) + x; % index of this vertex
			if x<w
				j = i+1; % next vertex to the right
				
				r(next_nonzero) = i;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = +1;
				next_nonzero = next_nonzero + 1;
				
				r(next_nonzero) = j;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = -1;
				next_nonzero = next_nonzero + 1;

				next_edge = next_edge + 1;

			end
		end
	end
		
	% next, the contiguous vertical ribs
		
  for x=1:k:w
	  for y=1:h
			i = w*(y-1) + x; % index of this vertex
			if y<h
				j = i+w; % next vertex down
								
				r(next_nonzero) = i;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = +1;
				next_nonzero = next_nonzero + 1;
				
				r(next_nonzero) = j;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = -1;
				next_nonzero = next_nonzero + 1;

				next_edge = next_edge + 1;

			end
		end
	end
	
	% finally, we create the combs

	for y=1:h
		if mod(y-1,k)==0 
			continue
		end
		for x=1:w
		  if mod(x,k)==0 
			  continue
		  end
			i = w*(y-1) + x; % index of this vertex
			if x<w
				j = i+1; % next vertex to the right
				
				r(next_nonzero) = i;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = +1;
				next_nonzero = next_nonzero + 1;
				
				r(next_nonzero) = j;
				c(next_nonzero) = next_edge;
			  v(next_nonzero) = -1;
				next_nonzero = next_nonzero + 1;

				next_edge = next_edge + 1;

			end
		end
	end

	% we now assemble the incidence factor
	
	cols = next_nonzero - 1;

	U = sparse(r(1:cols) ...
		        ,c(1:cols) ...
						,v(1:cols) ...
						,n,cols,2*cols);
	
	% now form p, from leaves up
	
	p = zeros(1,n);
	for y=1:h
		p((w-1)*(y-1)+1:(w-1)*y)=w*y : -1 : w*(y-1)+2;
	end	
	p((w-1)*h + 1:n) = 1:w:w*(h-1)+1;
	
end