function U = incidence(A)
% U = incidence(A)
% 
% Given an diagonally dominant matrix A,
% returns the canonical incidence factor of A

[i,j,v] = find(A);

U = [];
for e = 1:size(i,1)
    if (i(e) >= j(e)) 
        continue;
    end
    %[i(e)  j(e)]
    %pause
    tmp = sparse(size(A,1),1);
    tmp(i(e),1) = sqrt(abs(A(i(e),j(e))));
    tmp(j(e),1) = sqrt(abs(A(i(e),j(e))));
    if (A(i(e),j(e)) < 0)
        tmp(j(e),1) = -tmp(j(e),1);
    end
    U = [ U tmp ];
end

D = diag(diag(A));
s = sum(2*D-abs(A));

for v=1:length(s)
  if (s(v) > eps)
    tmp = sparse(size(A,1),1);
    tmp(v,1) = sqrt(s(v));
    full(tmp);
    U = [U tmp]; 
  end
end

