n = 100;
tol = 1e-4;
A_def = 10; % rank deficiency of A

A = rand(n,n);
[U,S,V] = svd(A);
A = U*S*U';

% this preconditioner is perfect, but full rank
P_Afull = A;

% this preconditioner is random, but the null
% space of A is an invariant subspace of it.
P_Asub = rand(n,n);
P_Asub = P_Asub * P_Asub';
P_Asub(A_def+1:n,1:A_def) = 0;
P_Asub(1:A_def,A_def+1:n) = 0;
P_Asub = U*P_Asub*U';

% this preconditioner is really random

x = rand(n,1);
b_inconsistent = A*x;

% now we create the actual A, rank deficient
P_rand = rand(n,n);
P_rand = P_rand * P_rand';

S(1:A_def,1:A_def) = 0;
A = U*S*U';

b_consistent = A*x;

sing_A = diag(S);
sing_A = sing_A(A_def+1:n);
kappa_A = max(sing_A)/min(sing_A)

disp('>>> no precond, consistent');
x_cons_minres = minres(A,b_consistent,tol,1000);
x_cons_cg     = pcg   (A,b_consistent,tol,1000);

disp('>>> no precond, inconsistent');
x_incons_minres = minres(A,b_inconsistent,tol,1000);
x_incons_cg     = pcg   (A,b_inconsistent,tol,1000);

disp('>>> precond, perfect full-rank precond, consistent');
x_cons_minres = minres(A,b_consistent,tol,1000,P_Afull);
x_cons_cg     = pcg   (A,b_consistent,tol,1000,P_Afull);

disp('>>> precond, null-space full-rank precond, consistent');
[X,FLAG,RELRES,ITER,RESVEC1] = minres(A,b_consistent,tol,1000,P_Asub);
[X,FLAG,RELRES,ITER,RESVEC2] = pcg   (A,b_consistent,tol,1000,P_Asub);

disp('>>> precond, random full-rank precond, consistent');
[X,FLAG,RELRES,ITER,RESVEC3] = minres(A,b_consistent,tol,1000,P_rand);
[X,FLAG,RELRES,ITER,RESVEC4] = pcg   (A,b_consistent,tol,1000,P_rand);

close all;
semilogy(RESVEC1);
hold on;
semilogy(RESVEC3,'r-');
hold off;
