function eigendistribution_plot(e,upper_limit)
% plots the distribution of real eigenvalues

e_min = min(e);
e_max = max(e);

if (e_min > 0)
  lower_limit = 0.9*e_min; % good for log scale
else
  lower_limit = e_min - (e_max - e_min)/10;
end

if (nargin < 2)
  upper_limit = e_max + (e_max - lower_limit)/10;
  if (e_min > 0 && upper_limit < 11*e_min)
      upper_limit = 11*e_min;
  end
end

figure;
set(gcf,'PaperUnits','centimeters');
set(gcf,'PaperPosition',[3,10,15,3]);

for i=1:length(e)
    line([e(i) e(i)],[0 1]);
end

axis([lower_limit,upper_limit,0,1]);
set(gca,'YTick',[])
set(gca,'Box','on')
if (e_min>0) 
  set(gca,'XScale','log')
end


end