// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "asset.h"

#include "MainFrm.h"
#include "ErrorDlg.h"

#include "model.h" 
#include "optimize.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_LOAD, OnUpdateFileLoad)
	ON_COMMAND(ID_SIMULATION_EXECUTE, OnSimulationExecute)
	ON_UPDATE_COMMAND_UI(ID_SIMULATION_EXECUTE, OnUpdateSimulationExecute)
	ON_COMMAND(ID_SIMULATION_STOP, OnSimulationStop)
	ON_UPDATE_COMMAND_UI(ID_SIMULATION_STOP, OnUpdateSimulationStop)
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_UPDATE_COMMAND_UI(ID_SIMULATION_RESET, OnUpdateSimulationReset)
	ON_COMMAND(ID_SIMULATION_RESET, OnSimulationReset)
	ON_COMMAND(ID_FILE_STORE, OnFileStore)
	ON_UPDATE_COMMAND_UI(ID_FILE_STORE, OnUpdateFileStore)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OPTIONS, OnUpdateViewOptions)
	ON_COMMAND(ID_VIEW_OPTIONS, OnViewOptions)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame() {		
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);	

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnFileOpen() {
	view = (CAssetView *)GetActiveView();	

	static char szFilter[] = "Model Files (*.mdl)|*.mdl|All Files (*.*)|*.*||";  
	CFileDialog dlg(TRUE,"mdl","*.mdl",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);

  if (dlg.DoModal()==IDOK) {
		// Load The System
    pSystem = new CSystem((LPCTSTR)dlg.GetPathName());	

	  if (pSystem->isSystemUp()) {
		  CString sTitle;
		  sTitle.Format("Running Model %s - Optimal Asset Allocation",dlg.GetFileName());
		  SetWindowText(sTitle);
			
			m_bSimulationRun=false;

			// Initialize the stock info viewers			
			if (SYSTEM_MODEL->getStocksCount() >=1) {
			  view->setStockInfoRange(1,SYSTEM_MODEL->getStockMin(1),
																	SYSTEM_MODEL->getStockMax(1));
				view->setStockInfoName(1,SYSTEM_MODEL->getStockName(1));
			}
			if (SYSTEM_MODEL->getStocksCount() >=2) {
			  view->setStockInfoRange(2,SYSTEM_MODEL->getStockMin(2),
																	SYSTEM_MODEL->getStockMax(2));
				view->setStockInfoName(2,SYSTEM_MODEL->getStockName(2));
			}

			view->setDecisionInfoSize(SYSTEM_MODEL->getStocksCount());
			nMaxValue = SYSTEM_MODEL->getPortfolioValue() *50;
			view->setValueInfoSize(int(nMaxValue));
		}
	  else {
			CErrorDlg err;
			CString message = "The file " + dlg.GetFileName() +
												" does not seem to be a valid model";
			err.setMessage(message);
			err.DoModal();

		  delete pSystem;
		  pSystem=0;
		}
	}	
}

void CMainFrame::OnUpdateFileOpen(CCmdUI* pCmdUI) {
	pCmdUI->Enable(!pSystem);
}

void CMainFrame::OnClose() {
	if (m_bSimulationRun) OnSimulationStop();

	if (pSystem) delete pSystem;
	pSystem=0;		

	CFrameWnd::OnClose();
}


// Run/Stop the simulation
/////////

void CMainFrame::OnSimulationExecute() {
	// Update parameters
	m_bAutomaticMode=(bool)m_dlgOptions.m_bAutomaticMode;

	SYSTEM_MODEL->setValueBinSize(m_dlgOptions.m_nBinSize);
	
	SYSTEM_OPTIMIZER->setEpsilon(m_dlgOptions.m_nEpsilon);
	SYSTEM_OPTIMIZER->setLambda(m_dlgOptions.m_nLambda);	

	if (m_dlgOptions.m_nAlphaType==0)
	  SYSTEM_OPTIMIZER->setAlpha(m_dlgOptions.m_nAlphaValue);
	else
		SYSTEM_OPTIMIZER->setAlpha(-1);

	if (m_dlgOptions.m_nActionType==0)
		SYSTEM_OPTIMIZER->setActionSelect(EGreedy);
	else
		SYSTEM_OPTIMIZER->setActionSelect(Softmax);

	// Start timer
	m_bSimulationRun=true;

	SetTimer(1,m_dlgOptions.m_nSimulationSpeed,NULL);
}

void CMainFrame::OnUpdateSimulationExecute(CCmdUI* pCmdUI) {
	pCmdUI->Enable(pSystem && !m_bSimulationRun);		
}

void CMainFrame::OnSimulationStop() {
	KillTimer(1);
	m_bSimulationRun=false;
}

void CMainFrame::OnUpdateSimulationStop(CCmdUI* pCmdUI) {
	pCmdUI->Enable(pSystem && m_bSimulationRun);			
}

void CMainFrame::OnTimer(UINT nIDEvent) {
	int nStocks = SYSTEM_MODEL->getStocksCount();
	int nStockInfo = (nStocks <MAX_STOCKINFO)?nStocks:MAX_STOCKINFO;

	// View market info
	for (int i=1;i <=nStockInfo;i++)
		view->setStockInfoValue(i,SYSTEM_MODEL->getStockValue(i));

	// Perform optimization
	CAction A = SYSTEM_OPTIMIZER->optimizeSingleCycle();

	// View portfolio info	
	view->setDecisionInfoValue(A.nStock);
	view->setValueInfoValue(SYSTEM_MODEL->getPortfolioValue());

	// View Policy info
	CString s;
	s.Format("%d",SYSTEM_OPTIMIZER->getCycles());
	view->m_editCyclesInfo.SetWindowText((LPCSTR)s);
	view->m_editCyclesInfo.UpdateWindow();

	s.Format("%d",SYSTEM_OPTIMIZER->getSignificantCycles());
	view->m_editSignificantInfo.SetWindowText((LPCSTR)s);
	view->m_editSignificantInfo.UpdateWindow();

	s.Format("%d",SYSTEM_MODEL->getDay());
	view->m_editDayInfo.SetWindowText((LPCSTR)s);
	view->m_editDayInfo.UpdateWindow();

	s.Format("%f",SYSTEM_MODEL->getPortfolioValue());
	view->m_editValueInfo.SetWindowText((LPCSTR)s);
	view->m_editValueInfo.UpdateWindow();

	if (m_bAutomaticMode)
	  if (SYSTEM_MODEL->getPortfolioValue()==0 ||
			  SYSTEM_MODEL->getPortfolioValue() >nMaxValue)
			OnSimulationReset();
	
	CFrameWnd::OnTimer(nIDEvent);
}

void CMainFrame::OnUpdateSimulationReset(CCmdUI* pCmdUI) {
	pCmdUI->Enable(pSystem && !m_bSimulationRun);			
}

void CMainFrame::OnSimulationReset() {
	view->resetInfo();
	SYSTEM_MODEL->restart();		
}


// Load/Save policy
/////////

void CMainFrame::OnFileLoad() {
	static char szFilter[] = "Policy Files (*.plc)|*.plc|All Files (*.*)|*.*||";  
	CFileDialog dlg(TRUE,"plc","*.plc",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);
	
  if (dlg.DoModal()==IDOK)
		SYSTEM_OPTIMIZER->loadPolicy((LPCTSTR)dlg.GetPathName());
}

void CMainFrame::OnUpdateFileLoad(CCmdUI* pCmdUI) {
	pCmdUI->Enable(pSystem && !m_bSimulationRun);				
}

void CMainFrame::OnFileStore() {
	static char szFilter[] = "Policy Files (*.plc)|*.plc|All Files (*.*)|*.*||";  
	CFileDialog dlg(FALSE,"plc","*.plc",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,szFilter);
	
  if (dlg.DoModal()==IDOK)
		SYSTEM_OPTIMIZER->savePolicy((LPCTSTR)dlg.GetPathName());
}

void CMainFrame::OnUpdateFileStore(CCmdUI* pCmdUI) {
	pCmdUI->Enable(pSystem && !m_bSimulationRun);				
}


// Set options
/////////

void CMainFrame::OnViewOptions() {
	m_dlgOptions.DoModal();
}


void CMainFrame::OnUpdateViewOptions(CCmdUI* pCmdUI) {
	pCmdUI->Enable(pSystem && !m_bSimulationRun);			
}

