// AssetView.h : interface of the CAssetView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ASSETVIEW_H__DEFF8BBB_1C14_11D4_B454_D96985E1B52B__INCLUDED_)
#define AFX_ASSETVIEW_H__DEFF8BBB_1C14_11D4_B454_D96985E1B52B__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "AssetDoc.h"
#include "OScopeCtrl.h"	

#define MAX_STOCKINFO 2

class CAssetView : public CFormView {
protected: // create from serialization only
	CAssetView();
	DECLARE_DYNCREATE(CAssetView)

public:
	//{{AFX_DATA(CAssetView)
	enum { IDD = IDD_ASSET_FORM };
	CEdit	m_editValueInfo;
	CEdit	m_editDayInfo;
	CEdit	m_editSignificantInfo;
	CEdit	m_editCyclesInfo;
	//}}AFX_DATA

// Attributes
public:
	CAssetDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAssetView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	void setStockInfoRange(int id, double dLower, double dUpper)
		{m_StockInfo[id -1].SetRange(dLower,dUpper);}
  void setStockInfoValue(int id, double dValue) 
		{m_StockInfo[id -1].AppendPoint(dValue);}
	void setStockInfoName(int id, CString name) 
		{m_StockInfo[id -1].SetYUnits(name);}

	void setDecisionInfoSize(int nSize)
		{m_DecisionInfo.SetRange(0.,nSize);}
  void setDecisionInfoValue(int nValue) 
		{m_DecisionInfo.AppendPoint(nValue);}

	void setValueInfoSize(int nUpper)
		{m_ValueInfo.SetRange(0.,nUpper);}
	void setValueInfoValue(double dValue) 
		{m_ValueInfo.AppendPoint(dValue);}

	void resetInfo();

	virtual ~CAssetView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	COScopeCtrl m_StockInfo[MAX_STOCKINFO];
	COScopeCtrl m_DecisionInfo;
	COScopeCtrl m_ValueInfo;

	//{{AFX_MSG(CAssetView)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in AssetView.cpp
inline CAssetDoc* CAssetView::GetDocument()
   { return (CAssetDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ASSETVIEW_H__DEFF8BBB_1C14_11D4_B454_D96985E1B52B__INCLUDED_)
