// AssetView.cpp : implementation of the CAssetView class
//

#include "stdafx.h"
#include "asset.h"

#include "AssetDoc.h"
#include "AssetView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAssetView

IMPLEMENT_DYNCREATE(CAssetView, CFormView)

BEGIN_MESSAGE_MAP(CAssetView, CFormView)
	//{{AFX_MSG_MAP(CAssetView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAssetView construction/destruction

CAssetView::CAssetView()
	: CFormView(CAssetView::IDD)
{
	//{{AFX_DATA_INIT(CAssetView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CAssetView::~CAssetView()
{
}

void CAssetView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAssetView)
	DDX_Control(pDX, IDC_VALUE_EDIT, m_editValueInfo);
	DDX_Control(pDX, IDC_DAY_EDIT, m_editDayInfo);
	DDX_Control(pDX, IDC_SIGNIFICANT_EDIT, m_editSignificantInfo);
	DDX_Control(pDX, IDC_CYCLES_EDIT, m_editCyclesInfo);
	//}}AFX_DATA_MAP
}

BOOL CAssetView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CAssetView diagnostics

#ifdef _DEBUG
void CAssetView::AssertValid() const
{
	CFormView::AssertValid();
}

void CAssetView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CAssetDoc* CAssetView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAssetDoc)));
	return (CAssetDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAssetView message handlers

void CAssetView::OnInitialUpdate() {
	CFormView::OnInitialUpdate();
	
	// Initialize stock info viewers
	// determine the rectangle for the control
  CRect rect[MAX_STOCKINFO];
  GetDlgItem(IDC_STOCKINFO1)->GetWindowRect(rect[0]);
  ScreenToClient(rect[0]) ;
	GetDlgItem(IDC_STOCKINFO2)->GetWindowRect(rect[1]);
  ScreenToClient(rect[1]) ;

  // create the control
	for (int i=0;i <MAX_STOCKINFO;i++) {
    m_StockInfo[i].Create(WS_VISIBLE | WS_CHILD, rect[i], this); 

    // customize the control
    m_StockInfo[i].SetRange(0.,100.,1);
    m_StockInfo[i].SetYUnits("");
    m_StockInfo[i].SetXUnits("");
    m_StockInfo[i].SetBackgroundColor(RGB(0, 0, 0));
    m_StockInfo[i].SetGridColor(RGB(220, 220, 220));
    m_StockInfo[i].SetPlotColor(RGB(255, 255, 0));	
	}

	// Initialize decision info viewer
	// determine the rectangle for the control  
  GetDlgItem(IDC_DECISIONINFO)->GetWindowRect(rect[0]);
  ScreenToClient(rect[0]) ;	

  // create the control	
  m_DecisionInfo.Create(WS_VISIBLE | WS_CHILD, rect[0], this); 

  // customize the control
  m_DecisionInfo.SetRange(0.,10.,1);
  m_DecisionInfo.SetYUnits("Action");
  m_DecisionInfo.SetXUnits("");
  m_DecisionInfo.SetBackgroundColor(RGB(0, 0, 0));
  m_DecisionInfo.SetGridColor(RGB(220, 220, 220));
  m_DecisionInfo.SetPlotColor(RGB(0, 255, 0));		

	// Initialize value info viewer
	// determine the rectangle for the control  
  GetDlgItem(IDC_VALUEINFO)->GetWindowRect(rect[0]);
  ScreenToClient(rect[0]) ;	

  // create the control	
  m_ValueInfo.Create(WS_VISIBLE | WS_CHILD, rect[0], this); 

  // customize the control
  m_ValueInfo.SetRange(0.,30.,1);
  m_ValueInfo.SetYUnits("Value");
  m_ValueInfo.SetXUnits("");
  m_ValueInfo.SetBackgroundColor(RGB(0, 0, 0));
  m_ValueInfo.SetGridColor(RGB(220, 220, 220));
  m_ValueInfo.SetPlotColor(RGB(255, 0, 0));		
}

void CAssetView::resetInfo() {
	for (int i=0;i <MAX_STOCKINFO;i++)
    m_StockInfo[i].Reset(); 

	m_DecisionInfo.Reset(); 
	m_ValueInfo.Reset(); 
}
