// stock.h
// Interface of a single stock in the market

#ifndef _STOCK_H
#define _STOCK_H

#include "common.h"


// This class implements

class CStock {
public:
	CStock(const char *sName, int nMin, int nMax, int nInit);
	~CStock();

  // Initialization methods
	void setTrend(tTrend &values);
	void setStability(tStability &values);

	// Access methods
	void restart();
	int nextDay();
  
	int getValue()	const {return nCurrent;}
	int getMin()		const {return nMin;}
	int getMax()		const {return nMax;}
	char *getName() const {return (char *)sName;}
	
private:
	char sName[MAX_NAME];
	int nMin, nMax, nInit;
	int nCurrent;

	tTrend trend;
	tStability stability;

	bool bInitialized, bTrendInitialized, bStabilityInitialized;	
};

#endif 
