// portfolio.h
// Interface of a asset portfolio

#ifndef _PORTFOLIO_H
#define _PORTFOLIO_H

#include "common.h"


// This class implements

class CPortfolio {
public:
	CPortfolio(tMoney nInitValue);
	~CPortfolio();  

	void restart();

	// Access Methods
	void invest(tStock nStock, float nPercentage);
	void pay(tMoney nAmount);
	void change(float nRatio);

	tStock getStock()					const {return nStock;}
	tMoney getValue()					const {return nValue;}
	tMoney getInvestedValue() const {return nValue *nPercentage;}
	float getPercentage()			const {return nPercentage;}	
		
private:
	tMoney nValue, nInitValue;	
	tStock nStock;
	float nPercentage;
};

#endif 
