// portfolio.cpp
// Implementation of a asset portfolio

#include "portfolio.h"


CPortfolio::CPortfolio(tMoney nInitValue) {
	CPortfolio::nInitValue=nInitValue;
	nValue=nInitValue;

	nStock=0;
	nPercentage=1.;

	INFO_MSG(("Portfolio::Portfolio is up, init value is %f\n",nInitValue));	
}

CPortfolio::~CPortfolio() {
	INFO_MSG(("Portfolio::Portfolio is down, last value was %f\n", nValue));
}

void CPortfolio::invest(tStock nStock, float nPercentage) {
	CPortfolio::nStock=nStock;
	CPortfolio::nPercentage=nPercentage; 

	if (nStock==0)
	  INFO_MSG(("Portfolio::Sold all investments\n"));	
	else
		INFO_MSG(("Portfolio::Invested %d%% of total value %f in stock #%d\n",int(nPercentage *100),nValue,nStock));	
}

void CPortfolio::pay(tMoney nAmount) {
	nValue=(nValue -nAmount >0)?nValue -nAmount:0;

	INFO_MSG(("Portfolio::Payed commision of %f, current value is %f\n",nAmount,nValue));	
}

void CPortfolio::change(float nRatio) {
	nValue=(float)(nPercentage *nValue *nRatio + (1. -nPercentage) *nValue);	

	INFO_MSG(("Portfolio::Investment changed in %d%%, current value is %f\n",int((nRatio -1.) *100),nValue));	
}

void CPortfolio::restart() {
	nValue=nInitValue;
	INFO_MSG(("Portfolio::Restarted portfolio, current amount is %f\n", nValue));
}
