// model.h
// Interface of stock market and asset portfolio model

#ifndef _MODEL_H
#define _MODEL_H

#include "common.h"
#include "market.h"
#include "portfolio.h"
#include "interface.h"


// This class implements

class CModel {
public:
	CModel(const char *sModelName, int nValueBinSize =1);
	~CModel();  

	// Action Methods
	void restart();
	tReward performAction(CAction &action);

	CState getState();	

	// Access Methods	
	void setValueBinSize(int n) {if (n >0) nValueBinSize=n;}

	bool isModelUp() const {return bModelUp;}
	int getDay()		 const {return nDay;}		

	tMoney getPortfolioValue() const {return pPortfolio->getValue();}
	int getStocksCount()			 const {return pMarket->getStocksCount();}
	int getStockValue(int id)  const {return pMarket->getStockValue(id);}
	int getStockMin(int id)		 const {return pMarket->getStockMin(id);}
	int getStockMax(int id)		 const {return pMarket->getStockMax(id);}
	char *getStockName(int id) const {return pMarket->getStockName(id);}
		
private:
	bool load(const char *sFileName);

	bool bModelUp;
	char sModelName[MAX_NAME];
	int nDay;	
	int nValueBinSize;

	CStockMarket *pMarket;
	CPortfolio   *pPortfolio;
};

#endif 
