// market.h
// Interface of a stock market

#ifndef _MARKET_H
#define _MARKET_H

#include "common.h"
#include "stock.h"


// This class implements

class CStockMarket {
public:
	CStockMarket();
	~CStockMarket();

  // Initialization methods
	int addStock(const char *sName, int nMin, int nMax, int nInit,
							 tTrend &trend, tStability &stability);

	// Access methods
	void restart();
	void nextDay();
  
	tMoney commission(eMarketAction action, tMoney nAmount);

	int getStockValue(int id) const;
	int getStockMin(int id) const;
	int getStockMax(int id) const;
	char *getStockName(int id) const;
	int getStocksCount() const {return nStocks;}
		
private:	
	int nStocks;
	CArray<CStock *, CStock *> stocks;	
};

#endif 
